package com.yizhi.application.service;

import cn.ms.sequence.SystemClock;
import com.alibaba.fastjson.JSONObject;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.system.application.controller.remote.CompanyStructureSchedulerController;
import com.yizhi.system.application.mapper.AccountMapper;
import com.yizhi.system.application.mapper.OrganizationMapper;
import com.yizhi.system.application.mapper.SiteMapper;
import com.yizhi.system.application.domain.Account;
import com.yizhi.system.application.domain.Organization;
import com.yizhi.system.application.vo.AccountRegisterVO;
import com.yizhi.system.application.vo.CompanyVO;
import com.yizhi.system.application.vo.ContactorVO;
import com.yizhi.system.application.vo.OrgVO;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

import java.util.*;

import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.content;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

/**
 * @Author: shengchenglong
 * @Date: 2018/6/6 11:39
 */
public class AuthTest extends BaseTest {

    // 模拟MVC对象，通过MockMvcBuilders.webAppContextSetup(this.wac).build()初始化。
    private MockMvc mockMvc;

    // 注入WebApplicationContext
    @Autowired
    private WebApplicationContext wac;
    @Autowired
    private CompanyStructureSchedulerController companyStructureSchedulerController;
    @Autowired
    private SiteMapper siteMapper;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private AccountMapper accountMapper;

    // 在测试开始前初始化工作
    @Before
    public void setup() {
        this.mockMvc = MockMvcBuilders.webAppContextSetup(this.wac).build();
    }

    /**
     * 新增企业
     */
    @Test
    public void insertCompanyTest() throws Exception {
        String url = "/manage/company/insert";
        RequestContext requestContext = this.getRequestContext("shyz", "shyz", "shyz", url);
        ContextHolder.set(requestContext);

        // 组装企业
        CompanyVO vo = new CompanyVO();
        vo.setAddress("安徽省合肥市");
        vo.setCategoryId(4);
        vo.setCode("LTZG");
        vo.setContext("重工企业");
        vo.setDomain("/ltzh");
        vo.setLogo("https://fulan-test.oss-cn-hangzhou.aliyuncs.com/baofei.jpg");
        vo.setName("龙腾重工");
        // 组装默认管理员
        AccountRegisterVO accountRegisterVO = new AccountRegisterVO();
        accountRegisterVO.setDescription(vo.getContext() + "默认管理员");
        accountRegisterVO.setEmail("shengchenglong@fulan.com.cn");
        accountRegisterVO.setFullName("盛承龙");
        accountRegisterVO.setMobile("99999");
        accountRegisterVO.setName("shengchenglong");
        accountRegisterVO.setPosition("董事长");
        accountRegisterVO.setSex("M");
        accountRegisterVO.setTelephone("99999");
        accountRegisterVO.setWorkNum("1");
        accountRegisterVO.setPassword("qwe123");
        vo.setSuperAdmin(accountRegisterVO);
        // 组装两个联系人
        List<ContactorVO> list = new ArrayList<>();
        ContactorVO contactorVO = new ContactorVO();
        contactorVO.setEmail("11111@qq.com");
        contactorVO.setName("联系人");
        contactorVO.setSex("M");
        contactorVO.setTelephone("1111111");

        ContactorVO contactorVO1 = new ContactorVO();
        contactorVO1.setEmail("11111@qq.com");
        contactorVO1.setName("联系人1");
        contactorVO1.setSex("F");
        contactorVO1.setTelephone("1111111");
        list.add(contactorVO);
        list.add(contactorVO1);
        vo.setContactorVOs(list);

        // 模拟请求
        MvcResult result =
                mockMvc.perform(
                        post(url).contentType(MediaType.APPLICATION_JSON).content(JSONObject.toJSONString(vo)))
                        .andExpect(status().isOk())
                        .andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8))
                        // 返回执行请求的结果
                        .andReturn();
        System.out.println(JsonFormatUtil.formatJson(result.getResponse().getContentAsString()));
    }

    /**
     * 添加部门，默认站点，默认管理员
     */
    @Test
    public void insertOrganizationDefaultSiteTest() throws Exception {
        String url = "/manage/org/insert";
        RequestContext requestContext = this.getRequestContext("shyz", "shengchenglong", "ltzg", url);
        ContextHolder.set(requestContext);

//        OrgVO orgVO = new OrgVO();
//        orgVO.setCode("LTZG_ANHUI");
//        orgVO.setDescription("龙腾安徽总公司");
//        orgVO.setName("安徽总公司");
//        orgVO.setParentId(requestContext.getOrgId());

//        OrgVO orgVO = new OrgVO();
//        orgVO.setCode("LTZG_HEFEI");
//        orgVO.setDescription("龙腾合肥分公司");
//        orgVO.setName("合肥分公司");
//        orgVO.setParentId(1004272204743237632L);

//        OrgVO orgVO = new OrgVO();
//        orgVO.setCode("LTZG_FEIDONG");
//        orgVO.setDescription("龙腾肥东分公司");
//        orgVO.setName("合肥肥东分公司");
//        orgVO.setParentId(1004274192847446016L);

//        OrgVO orgVO = new OrgVO();
//        orgVO.setCode("LTZG_SHANGHAI");
//        orgVO.setDescription("龙腾上海分公司");
//        orgVO.setName("上海分公司");
//        orgVO.setParentId(requestContext.getOrgId());

//        OrgVO orgVO = new OrgVO();
//        orgVO.setCode("LTZG_XUHUI");
//        orgVO.setDescription("龙腾浦徐汇分公司");
//        orgVO.setName("徐汇分公司");
//        orgVO.setParentId(1004274908337004544L);

        OrgVO orgVO = new OrgVO();
        orgVO.setCode("LTZG_YANGPU");
        orgVO.setDescription("龙腾浦杨浦分公司");
        orgVO.setName("杨浦分公司");
        orgVO.setParentId(1004274908337004544L);

        // 模拟请求
        MvcResult result =
                mockMvc.perform(
                        post(url).contentType(MediaType.APPLICATION_JSON).content(JSONObject.toJSONString(orgVO)))
                        .andExpect(status().isOk())
                        .andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8))
                        // 返回执行请求的结果
                        .andReturn();
        System.out.println(JsonFormatUtil.formatJson(result.getResponse().getContentAsString()));
    }

    /**
     * 添加管辖区
     */
    @Test
    public void insertUserGroupTest() throws Exception {
        String url = "/manage/group/insert";
        RequestContext requestContext = this.getRequestContext("shyz", "shengchenglong", "ltzg", url);
        ContextHolder.set(requestContext);

//        UserGroupVO groupVO = new UserGroupVO();
//        groupVO.setAccountIds();
//        groupVO.setOrgIds();





    }

    /**
     * 插入用户
     */
    @Test
    public void insertAccountTest() throws Exception {
        String url = "/manage/account/add";
        RequestContext requestContext = this.getRequestContext("shyz", "shengchenglong", "ltzg", url);
        ContextHolder.set(requestContext);

//        AccountRegisterVO accountRegisterVO = new AccountRegisterVO();
//        accountRegisterVO.setDescription("合肥分公司管理员");
//        accountRegisterVO.setEmail("shengchenglong@fulan.com.cn");
//        accountRegisterVO.setFullName("盛承龙合肥");
//        accountRegisterVO.setMobile("99999");
//        accountRegisterVO.setName("sclhf");
//        accountRegisterVO.setPosition("分公司董事长");
//        accountRegisterVO.setSex("M");
//        accountRegisterVO.setTelephone("99999");
//        accountRegisterVO.setWorkNum("2");
//        accountRegisterVO.setPassword("qwe123");
//        accountRegisterVO.setOrgId(1004274192847446016L);

//        AccountRegisterVO accountRegisterVO = new AccountRegisterVO();
//        accountRegisterVO.setDescription("安徽总司管理员");
//        accountRegisterVO.setEmail("shengchenglong@fulan.com.cn");
//        accountRegisterVO.setFullName("盛承龙安徽");
//        accountRegisterVO.setMobile("99999");
//        accountRegisterVO.setName("sclhah");
//        accountRegisterVO.setPosition("总公司董事长");
//        accountRegisterVO.setSex("M");
//        accountRegisterVO.setTelephone("99999");
//        accountRegisterVO.setWorkNum("2");
//        accountRegisterVO.setPassword("qwe123");
//        accountRegisterVO.setOrgId(1004272204743237632L);

        AccountRegisterVO accountRegisterVO = new AccountRegisterVO();
        accountRegisterVO.setDescription("徐汇分司员工");
        accountRegisterVO.setEmail("shengchenglong@fulan.com.cn");
        accountRegisterVO.setFullName("盛承龙徐汇2");
        accountRegisterVO.setMobile("99999");
        accountRegisterVO.setName("sclxh2");
        accountRegisterVO.setPosition("分公司员工");
        accountRegisterVO.setSex("M");
        accountRegisterVO.setTelephone("99999");
        accountRegisterVO.setWorkNum("7");
        accountRegisterVO.setPassword("qwe123");
        accountRegisterVO.setOrgId(1004276268788940800L);

        // 模拟请求
        MvcResult result =
                mockMvc.perform(
                        post(url).contentType(MediaType.APPLICATION_JSON).content(JSONObject.toJSONString(accountRegisterVO)))
                        .andExpect(status().isOk())
                        .andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8))
                        // 返回执行请求的结果
                        .andReturn();
        System.out.println(JsonFormatUtil.formatJson(result.getResponse().getContentAsString()));
    }

    /**
     * 组织部门树查看
     */
    @Test
    public void organizationTreeViewTest() throws Exception {
        String url = "/manage/org/userGroup/list";
        RequestContext requestContext = this.getRequestContext("shyz", "sclah", "anlt", url);
        ContextHolder.set(requestContext);

        // 模拟请求
        MvcResult result =
                mockMvc.perform(
                        get(url + "?type=system").contentType(MediaType.APPLICATION_FORM_URLENCODED_VALUE))
                        .andExpect(status().isOk())
                        .andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8))
                        // 返回执行请求的结果
                        .andReturn();
        System.out.println(JsonFormatUtil.formatJson(result.getResponse().getContentAsString()));
    }

    /**
     * 检索用户搜索
     *
     * @throws Exception
     */
    @Test
    public void nameSearchTest() throws Exception {
        String urlToTest = "/manage/account/name/search";
        RequestContext requestContext = this.getRequestContext("shyz","sclsh", "ltzg", urlToTest);
        ContextHolder.set(requestContext);

        MvcResult result =
                mockMvc.perform(
                        get(urlToTest + "?type=system&seachVal=scl").contentType(MediaType.APPLICATION_FORM_URLENCODED_VALUE))
                        // 模拟向testRest发送get请求
                        .andExpect(status().isOk())
                        // 预期返回值的媒体类型text/plain;charset=UTF-8
                        .andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8))
                        // 返回执行请求的结果
                        .andReturn();
        System.out.println(JsonFormatUtil.formatJson(result.getResponse().getContentAsString()));

    }

    /**
     * 查看部门下用户
     *
     * @throws Exception
     */
    @Test
    public void accountListTest() throws Exception {
        String urlToTest = "/manage/account/list";
        RequestContext requestContext = this.getRequestContext("shyz", "shengchenglong", "ltzg", urlToTest);
        ContextHolder.set(requestContext);

        MvcResult result =
                mockMvc.perform(
                        get(urlToTest + "?orgId=1004272204743237632")
                                .contentType(MediaType.APPLICATION_FORM_URLENCODED_VALUE))
                        // 模拟向testRest发送get请求
                        .andExpect(status().isOk())
                        // 预期返回值的媒体类型text/plain;charset=UTF-8
                        .andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8))
                        // 返回执行请求的结果
                        .andReturn();
        System.out.println(JsonFormatUtil.formatJson(result.getResponse().getContentAsString()));
    }

    @Test
    public void upgradeOrgViewFun() throws Exception {
        String url = "/manage/org/userGroup/list";
        RequestContext requestContext = this.getRequestContext("shyz", "shyz", "shyz", url);
        ContextHolder.set(requestContext);

        Long strarTime = SystemClock.now();
        // 模拟请求
        MvcResult result =
                mockMvc.perform(
                        get(url + "?type=system").contentType(MediaType.APPLICATION_FORM_URLENCODED_VALUE))
                        .andExpect(status().isOk())
                        .andExpect(content().contentType(MediaType.APPLICATION_JSON_UTF8))
                        // 返回执行请求的结果
                        .andReturn();
        System.out.println("耗时：--------  " + (SystemClock.now() - strarTime));
    }

}
