package com.yizhi.application.service;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.system.application.mapper.AuthzMenuMapper;
import com.yizhi.system.application.mapper.AuthzMenuResourceMapper;
import com.yizhi.system.application.mapper.AuthzResourceMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.system.application.domain.AuthzResource;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.junit4.SpringRunner;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *
 *
 * @Author: shengchenglong
 * @Date: 2018/5/29 13:59
 */
@SpringBootTest
@RunWith(SpringRunner.class)
public class ImportUrlExcelTest {

    @Autowired
    private AuthzResourceMapper operationMapper;
    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private AuthzMenuMapper authzMenuMapper;
    @Autowired
    private AuthzMenuResourceMapper authzMenuOperationMapper;

    @Test
    public void createModuleByOperation() {
//        List<Operation> operations = operationMapper.selectList(new EntityWrapper<>());
//        System.out.println(operations);
//
//        for (Operation o : operations) {
//            AuthzMenu m = new AuthzMenu();
//            m.setId(o.getId());
//            m.setType(1);
//            m.setDescription(o.getName());
//            m.setName(o.getName());
//            m.setParentId(o.getParentId());
//            m.setEnabled(1);
//            authzMenuMapper.insert(m);
//        }
    }

    /**
     * 插入模块
     * 插入菜单
     * 插入模块、菜单关联
     * @throws IOException
     * @throws ParseException
     */
//    @Test
//    public void insertMenu() throws IOException, ParseException {
//        //读取xlsx文件
//        File file = new File("/Users/shengchenglong/Documents/IdeaProjects/wmy_workspace/elearn/cloud-system/src/test/resources/menus.xls");
//        HSSFWorkbook wb = new HSSFWorkbook(new FileInputStream(file));
//
//        HSSFSheet sheet = wb.getSheetAt(0);
//
//        System.out.println("------------------------------------------------------------");
//        System.out.println(sheet.getLastRowNum());
//
//        HSSFRow row = null;
//        HSSFCell cell = null;
//
//        List<Operation> list = new ArrayList<>();
//
//        for (int i = 1; i <= sheet.getLastRowNum(); i++) {
//            row = sheet.getRow(i);
//
//            Operation o = new Operation();
//            o.setId((long) row.getCell(0).getNumericCellValue());
//            o.setType("M");
//            o.setEnabled(Boolean.valueOf(true));
//            o.setParentId((long) row.getCell(4).getNumericCellValue());
//            if (row.getCell(7) != null) {
//                o.setUrl(row.getCell(7).getStringCellValue());
//            }
//            o.setName(row.getCell(1).getStringCellValue());
//            o.setCreateTime(DateUtils.parseDate(row.getCell(9).getStringCellValue(), "yyyy-MM-dd HH:ss:mm"));
//            o.setCreateByName("0");
//            o.setCreateById(0L);
//            System.out.println(o.toString());
////            operationMapper.insert(o);
//
//            if (row.getCell(6) != null
//                    && row.getCell(6).getStringCellValue().equals("y")) {
//                // 插入模块
//                AuthzMenu m = new AuthzMenu();
//                m.setId(o.getId());
//                m.setType(1);
//                m.setDescription(o.getName());
//                m.setName(o.getName());
//                m.setParentId(o.getParentId());
//                m.setEnabled(1);
//                System.out.println(m.toString());
////                authzMenuMapper.insert(m);
//            }
//
//            // 插入模块与菜单的关联 module_operation
//            AuthzMenuOperation mo = new AuthzMenuOperation();
//            mo.setId(idGenerator.generate());
//            mo.setResourceId(o.getId());
//            mo.setMenuId((long) row.getCell(10).getNumericCellValue());
//            mo.setCreateTime(DateUtils.parseDate(row.getCell(9).getStringCellValue(), "yyyy-MM-dd HH:ss:mm"));
//            mo.setCreateByName("0");
//            mo.setCreateById(0L);
//            authzMenuOperationMapper.insert(mo);
//
//        }
//    }

//    @Test
//    public void addUrl() throws IOException, ParseException {
//        //读取xlsx文件
//        File file = new File("/Users/shengchenglong/Documents/IdeaProjects/wmy_workspace/elearn/cloud-system/src/test/resources/urls-new-0829.xls");
//        HSSFWorkbook wb = new HSSFWorkbook(new FileInputStream(file));
//
//        HSSFSheet sheet = wb.getSheetAt(0);
//
//        System.out.println("------------------------------------------------------------");
//        System.out.println(sheet.getLastRowNum());
//
//        HSSFRow row = null;
//        HSSFCell cell = null;
//
//        List<Operation> list = new ArrayList<>();
//
//        for (int i = 1; i <= sheet.getLastRowNum(); i++) {
//            try {
//                row = sheet.getRow(i);
//
////                if (row.getCell(5).getNumericCellValue() == 0) {
////                    continue;
////                }
//
//
//                Operation o = new Operation();
//                o.setId(idGenerator.generate());
//                o.setParentId(0L);
//                o.setEnabled(true);
//                o.setOperationMenu(false);
//                o.setType("B");
//                o.setCreateById(0L);
//                o.setCreateByName("0");
//                o.setCreateTime(DateUtils.parseDate(row.getCell(6).getStringCellValue(), "yyyy-MM-dd HH:ss:mm"));
//
//                cell = row.getCell(2);
//                o.setName(cell.getStringCellValue());
//                cell = row.getCell(4);
//                o.setUrl(cell.getStringCellValue());
//                cell = row.getCell(5);
//
//                AuthzMenuOperation mo = new AuthzMenuOperation();
//                mo.setCreateById(0L);
//                mo.setCreateByName("0");
//                mo.setCreateTime(o.getCreateTime());
//                mo.setId(idGenerator.generate());
//                mo.setMenuId((long) cell.getNumericCellValue());
//                mo.setResourceId(o.getId());
//
//                System.out.println(o.toString());
//                System.out.println(mo.toString());
//
//                operationMapper.insert(o);
//                authzMenuOperationMapper.insert(mo);
//            } catch (NullPointerException e) {
//                e.printStackTrace();
//                continue;
//            }
//
//
//        }
//
//    }

    @Test
    public void compare() throws IOException, ParseException {
        //读取xlsx文件
        File file = new File("/Users/shengchenglong/Documents/IdeaProjects/wmy_workspace/elearn/cloud-system/src/test/resources/urls-web-0704.xls");
        HSSFWorkbook wb = new HSSFWorkbook(new FileInputStream(file));

        HSSFSheet sheet = wb.getSheetAt(0);

        System.out.println("------------------------------------------------------------");
        System.out.println(sheet.getLastRowNum());

        HSSFRow row = null;
        HSSFCell cell = null;

        AuthzResource operation = new AuthzResource();
        List<AuthzResource> operations = operation.selectList(new EntityWrapper(operation));
        Map<String, AuthzResource> map = new HashMap<>();
        for (AuthzResource o : operations) {
            map.put(o.getUrl(), o);
        }

        for (int i = 1; i <= sheet.getLastRowNum(); i++) {
            row = sheet.getRow(i);
            if (!map.keySet().contains(row.getCell(4).getStringCellValue())) {
                System.out.println(row.getCell(4).getStringCellValue());
            }

        }

    }
}
