package com.yizhi.util.application.clazz;

import com.yizhi.util.application.date.DateUtil;
import com.yizhi.util.application.enums.FieldType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Date;


public class ClassUtil {
	private static final Logger logger = LoggerFactory.getLogger(ClassUtil.class);

	public static boolean existMethod(Class clazz,String methodName) {
		Method method = null;
		try {
			method = clazz.getMethod(methodName, null);
		} catch (Exception e) {
		}
		
		return method != null;
	}
	
	
	protected static long getDatacenterId(long maxDatacenterId) {
        long id = 0L;
        try {
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            if (network == null) {
                id = 1L;
            } else {
                byte[] mac = network.getHardwareAddress();
                if (null != mac) {
                    id = ((0x000000FF & (long) mac[mac.length - 1]) | (0x0000FF00 & (((long) mac[mac.length - 2]) << 8))) >> 6;
                    id = id % (maxDatacenterId + 1);
                }
            }
        } catch (Exception e) {
        }
        return id;
}
	
    protected static long getMaxWorkerId(long datacenterId, long maxWorkerId) {
        StringBuilder mpid = new StringBuilder();
        mpid.append(datacenterId);
        String name = ManagementFactory.getRuntimeMXBean().getName();
        if (StringUtils.isNotEmpty(name)) {
            /*
             * GET jvmPid
			 */
            mpid.append(name.split("@")[0]);
        }
        /*
         * MAC + PID 的 hashcode 获取16个低位
		 */
        return (mpid.toString().hashCode() & 0xffff) % (maxWorkerId + 1);
}

	public static void main(String[] args) {
		getMaxWorkerId(0,31);
	}
	
	public static <T> String invokeMethod(T t,String fieldName) {
		Method method = null;
		//获取get方法名
        try {
    		String methodName = fieldName.substring(0, 1).toUpperCase()+ fieldName.substring(1);
            method = t.getClass().getMethod("get" + methodName);
        } catch (NoSuchMethodException e) {
            logger.error("获取get方法异常",e);
        }
        //获取属性值
        String fieldValue="";
        try{  
    		String fieldType = t.getClass().getDeclaredField(fieldName).getGenericType().toString();        	     	
        	if(fieldType.equals(FieldType.DATE.getCode())){
        		fieldValue=DateUtil.toSeconds((Date)method.invoke(t));
        	}else if(fieldType.equals(FieldType.BOOLEAN.getCode())||fieldType.equals(FieldType.BOOLEANB.getCode())){
        		fieldValue=(boolean)method.invoke(t)?"1":"0";
        	}else{
        		fieldValue=String.valueOf(method.invoke(t));
        	}
        }catch (Exception e){
        	logger.error("获取属性值异常",e);
        }
        return fieldValue;
	}

    /**
     * 把表字段名转换驼峰命名
     * @param fieldName
     * @return
     */
    public static String getFieldName(String fieldName) {
        if (StringUtils.isNotBlank(fieldName)) {
            if (fieldName.indexOf("_") > 0) {
                String a[] = fieldName.split("_");
                String upperCase = a[1].substring(0,1).toUpperCase();
                fieldName = a[0].concat(upperCase).concat(a[1].substring(1));
            }
        }
        return fieldName;
    }

    /**
     * 功能：驼峰命名转下划线命名
     * 小写和大写紧挨一起的地方,加上分隔符,然后全部转小写
     */
    public static String getDomainField(String c)
    {
        String separator = "_";
        c = c.replaceAll("([a-z])([A-Z])", "$1"+separator+"$2").toLowerCase();
        return c;
    }

}
