package com.yizhi.util.application.constant;

import com.alibaba.fastjson.JSONObject;
import com.yizhi.util.application.json.JsonUtil;

/**
 * 响应返回码
 * 如果是业务错误,则需要在微服务里定义错误子类型
 */
@Deprecated
public enum ReturnCode {
	
	SUCCESS("1000","接口调用成功"),
	SERVICE_UNAVAILABLE("2000","服务不可用"),
	NO_TOKEN("2001","没有令牌信息,请重新登陆"),
	TOKEN_INVALID("2002","令牌无效或已过期"),
	PARAM_INVALID("3000","参数不全或参数非法"),
	RESOURCE_NOT_FOUND("3001","资源没找到或不存在"),
	RESOURCE_EXIST("3002","资源已存在"),
    MOBILE_EXIST("3024","手机号码已经存在"),
	READ_FILE_FAIL("3003","文件读取失败"),
	SAVE_FAIL("3004","保存失败"),
	UPDATE_FAIL("3007","更新失败"),
	DELETE_FAIL("3005","删除失败"),
	NOT_ALLOWED_COMPANY("3006","对企业权限不够，操作被不允许"),
	NOT_COMPANY_EXTIS("3008","指定访问的企业code信息不存在，拒绝访问"),
	NOT_COMPANY_PARAM_INVALID("3009","没有指定访问的企业code，拒绝访问"),
	NOT_ALLOWED_SITE("3010","对站点权限不够，操作被不允许"),
	NOT_SITE_EXTIS("3011","请求指定企业code信息不存在"),
	COMPANY_NOT_LOGIN("3012","您已切换了访问的企业，请重新登陆"),
	NOT_SITE_CODE("3013","没有指定访问的站点code，拒绝访问"),
	NOT_SITE_INFO_CODE("3014","指定的站点code信息不存在，拒绝访问"),
	NOT_SITE_ACCESS("3015","没有站点访问权限，拒绝访问"),
	NOT_ROLE_OPERATION("3016","没有角色操作权限，拒绝访问"),
	SITE_NOT_LOGIN("3017","您已切换了访问的站点，请重新登陆"),

	NO_INTERFACE_ACCESS("3020", "没有任何接口权限，拒绝访问"),
	NO_CURRENT_INTERFACE_ACCESS("3021", "没有当前接口权限，拒绝访问"),
	NO_CURRENT_INTERFACE_MANAGER("3022", "当前接口权限下没有管理对象，拒绝访问"),
	NO_CURRENT_INTERFACE_MANAGER_CHILDORG("3023", "当前接口权限下没有管理对象（查询子部门错误），拒绝访问"),
	
	NO_CONTENT("3025","请输入内容"),

	BIZ_FAIL("4000","业务处理失败"),
	ACCOUNT_CLOSE("5000","账号未开通或者被锁定"),
    NOT_SITE_AUTH("4010","账号没有访问此服务的权限，请联系管理员开通!"),
    NOT_EXIST_ACCOUNT("4011","您当前的账号不属于访问企业,无法访问!"),
    DISABLE_ACCOUNT("4012","您当前使用账号已处于停用状态!"),
    NOT_RELATE_ACCOUNT("4013","您当前的微信号未关联系统账号,请先登录!" ),
	ACCOUNT_INVALID("5001","账号已经失效"),
	ACCOUNT_BIND("8000","登录账号已经绑定其他的微信!"),
    OPENID_BIND("8001","该微信已经绑定过其他的系统账号!"),
    SIGN_FAIL("7004","验签失败!"),
    USER_PWD_FAIL("7005", "密码不符合规范"),
    PASSWORD_ERROR("4000","密码错误"),
    ACCOUNT_NOT_EXIST("4000","账号不存在"),
    SITE_PROTECT("5005","站点维护"),
    DUPLICATE_REQUEST("4000","重复的请求");
	// 错误子类型标记
	public static final String API_SUB_FLAG = "subCode";
	
	private String code;
	private String msg;
	
	ReturnCode(String code,String msg){
		this.code = code;
		this.msg = msg;
	}
	
	public String getCode() {
		return code;
	}

	public String getMsg() {
		return msg;
	}


	public String toJson() {
		return JsonUtil.object2Json(this);
	}

	/**
	 * Returns the name of this enum constant, as contained in the
	 * declaration.  This method may be overridden, though it typically
	 * isn't necessary or desirable.  An enum type should override this
	 * method when a more "programmer-friendly" string form exists.
	 *
	 * @return the name of this enum constant
	 */
	@Override
	public String toString() {
		JSONObject object = new JSONObject();
		object.put("code",code);
		object.put("msg",msg);
		return object.toString();
	}
}
