package com.yizhi.util.application.domain;

import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.enums.i18n.Constants;
import com.yizhi.util.application.page.PageInfo;
import com.yizhi.util.application.page.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.tuple.Pair;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 响应数据封装类
 * subCode和subMsg应该在各微服务里如ReturnCode定义具体业务错误枚举信息
 * 此类已过期，请使用 BizResponse
 * @see com.yizhi.util.application.domain.BizResponse
 * @author scotthu
 *
 * @param <T>
 */
@Deprecated()
@ApiModel(value = "response", description = "响应信息封装")
public class Response<T> implements Serializable {

	private static final long serialVersionUID = 1L;

	public static final String PAGE_PARAM_PAGE_NO = "pageNo";
	public static final String PAGE_PARAM_PAGE_SIZE = "pageSize";
	public static final String PAGE_PARAM_PAGE_TOTAL = "pageTotal";


	@ApiModelProperty(notes = "响应代码")
	private String code = Constants.MSG_SUCCESS.getCode().toString(); //响应码
	@ApiModelProperty(notes = "响应信息")
	private String msg  = Constants.MSG_SUCCESS.getName();  //响应说明
	
	@ApiModelProperty(notes = "业务错误码")
	private String subCode; //业务响应码
	@ApiModelProperty(notes = "业务错误说明")
	private String subMsg;  //业务错误说明
	
	@ApiModelProperty(notes = "响应数据")
	protected transient Object data; //响应数据

	@ApiModelProperty(notes = "分页信息")
	protected transient Map<String,Integer> page;

	private Response() {

	}
	
	/**
	 * 返回成功响应
	 */
	public static <T> Response<T> ok() {
		Response<T> response = new Response<T>();
		response.code = Constants.MSG_SUCCESS.getCode().toString();
		response.msg = Constants.MSG_SUCCESS.getName();
		return response;
	}
	
	/**
	 * 返回成功响应,携带数据
	 */
	public static <T> Response<T> ok(Object data) {
		Response<T> response = ok();
		response.data = data;
		return response;
	}

	@Deprecated
	/**
	 * 返回成功响应,携带数据
	 */
	public static <T> Response<T> ok(Object data,Map<String,Integer> page) {
		Response<T> response = ok();
		response.data = data;
		response.page = page;
		return response;
	}

	@Deprecated
	/**
	 * 返回成功响应,携带列表数据和分页信息
	 * @param dataAndPage
	 */
	public static <T> Response<T> ok(Pair<List<T>,Map<String,Integer>> dataAndPage) {
		Response<T> response = ok();
		response.data = dataAndPage.getLeft();
		response.page = dataAndPage.getRight();
		return response;
	}

    public static <T> Response<T> ok(String subCode,String subMsg) {
        Response<T> response = ok();
        response.subCode = subCode;
        response.subMsg = subMsg;
        return response;
    }

    /**
	 * 返回成功响应
	 */
	public static <T> Response<T> ok(String code, String msg, Object data) {
		Response<T> response = new Response<T>();
		response.code = code;
		response.msg = msg;
		response.data = data;
		
		return response;
	}
	
    @Deprecated
	/**
	 * 以后弃用，必须返回自己业务的subCode和subMsg
	 */
	public static <T> Response<T> fail() {
		Response<T> response = new Response<T>();
		response.code = Constants.MSG_BIZ_FAIL.getCode().toString();
		response.msg = Constants.MSG_BIZ_FAIL.getName();
		return response;
	}

	@Deprecated
	/**
	 * 新的消息返回必须Constants枚举类定义
	 */
	public static <T> Response<T> fail(ReturnCode returnCode) {
		Response<T> response = fail();
		response.code = returnCode.getCode();
		response.msg = returnCode.getMsg();
		return response;
	}

	public static <T> Response<T> fail(Constants returnCode) {
		Response<T> response = fail();
		response.subCode = returnCode.getCode().toString();
		response.subMsg = returnCode.getName();
		return response;
	}

	public static <T> Response<T> fail(String subCode,String subMsg) {
		Response<T> response = fail();
		response.subCode = subCode;
		response.subMsg = subMsg;
		return response;
	}
	
	public static <T> Response<T> fail(String subMsg) {
		Response<T> response = fail();
		response.subMsg = subMsg;
		return response;
	}

	public static <T> Response<T> fail(String code, String msg, Object data) {
		Response<T> response = new Response<T>();
		response.code = code;
		response.msg = msg;
		response.data = data;
		return response;
	}
	
	public Object getData() {
		return data;
	}

	public String getCode() {
		return code;
	}

	public String getMsg() {
		return msg;
	}

	public String getSubCode() {
		return subCode;
	}

	public String getSubMsg() {
		return subMsg;
	}

	public Map<String,Integer> getPage(){
		return page;
	}

	public Response withPageNo(Integer pageNo) {
		beforeWithPage();
		this.page.put(PAGE_PARAM_PAGE_NO, pageNo);
		return this;
	}

	public Response withPageSize(Integer pageSize) {
		beforeWithPage();
		this.page.put(PAGE_PARAM_PAGE_SIZE, pageSize);
		return this;
	}

	public Response withPageTotal(Integer pageTotal) {
		beforeWithPage();
		this.page.put(PAGE_PARAM_PAGE_TOTAL, pageTotal);
		return this;
	}

	public Response withPage(Integer pageNo, Integer pageSize, Integer pageTotal) {
		return this.withPageNo(pageNo).withPageSize(pageSize).withPageTotal(pageTotal);
	}

	public Response withPageParam(PageParam pageParam) {
		return this.withPageNo(pageParam.getPageNo()).withPageSize(pageParam.getPageSize()).withPageTotal(pageParam.getPageTotal());
	}

	public Response withPageInfo(PageInfo pageInfo) {
		return Response.ok(pageInfo.getRecords()).withPageParam(pageInfo);
	}

	private void beforeWithPage() {
		Map<String, Integer> page = this.page;
		if (page == null) {
			this.page = new HashMap<>();
		}
	}

}
