package com.yizhi.util.application.encrypt;

import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 17:17 2018/3/26
 * @Modified By
 */
public class ShaEncrypt {

    private static final String BASE_SALT = "vmobel_1qaz@WSX";

    private static final String SPLIT_STR = "|";

    private static Logger logger = LoggerFactory.getLogger(ShaEncrypt.class);

    /**
     * 比较密码是否相等
     * @param clearTextPasswords 请求的明文密码字符串
     * @param encryptPassword 加密过的密码字符串
     * @return
     */
    public static boolean comparePassword(String clearTextPasswords, String encryptPassword){
        boolean verifyThrough = false;
        int index = encryptPassword.indexOf(SPLIT_STR);
        if(index<0){
            logger.info("密码");
            return verifyThrough;
        }
        String random_salt = encryptPassword.substring(0,encryptPassword.indexOf(SPLIT_STR));
        if(StringUtils.isNotBlank(random_salt)){
            String origin_text = BASE_SALT + clearTextPasswords + random_salt;
            String ePassword = getSHA256Str(origin_text);
            ePassword = random_salt + SPLIT_STR + ePassword;
            return ePassword.equals(encryptPassword);
        }
        return verifyThrough;
    }

    /**
     * 对明文新密码密码进行加密
     * @param password 明文密码
     * @return
     */
    public static String encryptNewPassword(String password){
        String random_salt = UUID.randomUUID().toString().replace("-", "");
        String origin_text = BASE_SALT + password + random_salt;
        String ePassword = getSHA256Str(origin_text);
        if(StringUtils.isNotBlank(ePassword)){
            return random_salt+SPLIT_STR+ePassword;
        }
        return null;
    }
    /**
     * 利用Apache的工具类实现SHA-256加密
     * @param str
     * @return
     */
    public static String getSHA256Str(String str){
        MessageDigest messageDigest;
        String encdeStr = "";
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] hash = messageDigest.digest(str.getBytes("UTF-8"));
            encdeStr = Hex.encodeHexString(hash);
        } catch (NoSuchAlgorithmException e) {
            logger.error("sha256加密失败NoSuchAlgorithmException："+e.getMessage());
        } catch (UnsupportedEncodingException e) {
            logger.error("sha256加密失败UnsupportedEncodingException："+e.getMessage());
        }
        return encdeStr;
    }

    /**
     * 利用java原生的摘要实现SHA256加密
     * @param str
     * @return
     */
    public static String getSHA256StrJava(String str){
        MessageDigest messageDigest;
        String encodeStr = "";
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(str.getBytes("UTF-8"));
            encodeStr = byte2Hex(messageDigest.digest());
        } catch (NoSuchAlgorithmException e) {
            logger.error("sha256加密失败NoSuchAlgorithmException："+e.getMessage());
        } catch (UnsupportedEncodingException e) {
            logger.error("sha256加密失败UnsupportedEncodingException："+e.getMessage());
        }
        return encodeStr;
    }

    /**
     * 将byte转为16进制
     * @param bytes
     * @return
     */
    private static String byte2Hex(byte[] bytes){
        StringBuffer stringBuffer = new StringBuffer();
        String temp = null;
        for (int i=0;i<bytes.length;i++){
            temp = Integer.toHexString(bytes[i] & 0xFF);
            if (temp.length()==1){
                //1得到一位的进行补0操作
                stringBuffer.append("0");
            }
            stringBuffer.append(temp);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] args) {
        System.out.println(ShaEncrypt.encryptNewPassword("123456"));
    }
}
