package com.yizhi.util.application.event;

import com.yizhi.util.application.constant.TpActivityType;
import lombok.AllArgsConstructor;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author: shengchenglong
 * @Date: 2018/4/17 13:30
 */
@Data
@AllArgsConstructor
public class TrainingProjectEvent implements Serializable {

    /**
     * 发生的业务主体主键
     */
    private Long id;

    /**
     * 消息发送方服务类型
     *
     * @see TpActivityType
     */
    private Integer type;

    /**
     * 学员id
     */
    private Long accountId;

    /**
     * 业务处理时间
     */
    private Date now;

    /**
     * 考试业务有效：考试分数
     */
    private Float examScore;

    /**
     * 报名业务有效：所报名的培训项目的id
     */
    private Long trainingProjectId;

    /**
     * 课程业务有效：学习时长
     */
    private Long courseSeconds;

    /**
     * 课程业务有效：课程是否已经完成
     */
    private Boolean courseFinished;

    /**
     * 业务发生站点id
     */
    private Long siteId;

    /**
     * 判断是否为补发字段
     */
    private Integer isCustom;


    /**
     * 普通业务发生用(默认完成)
     *
     * @param id        业务id
     * @param type      TpEventConstant
     * @param accountId 触发业务账号id
     * @param now       触发业务时间
     * @param siteId    站点id
     * @return
     */
    public static TrainingProjectEvent getInstance(Long id, Integer type, Long accountId, Date now, Long siteId) throws Exception {
        if (id == null || type == null || accountId == null || now == null || siteId == null) {
            throw new Exception("参数有误，请检查");
        }
        return new TrainingProjectEvent(id, type, accountId, now, null, null, null, Boolean.TRUE, siteId, null);
    }


    /**
     * 普通业务发生用
     *
     * @param id        业务id
     * @param type      TpEventConstant
     * @param accountId 触发业务账号id
     * @param now       触发业务时间
     * @param siteId    站点id
     * @param score     获得分数
     * @param finished  是否完成
     * @return
     */
    public static TrainingProjectEvent getInstance(Long id, Integer type, Long accountId, Date now, Long siteId, Float score, Boolean finished) throws Exception {
        if (id == null || type == null || accountId == null || now == null || siteId == null) {
            throw new Exception("参数有误，请检查");
        }
        return new TrainingProjectEvent(id, type, accountId, now, score, null, null, finished, siteId, null);
    }

    /**
     * 普通业务发生用
     *
     * @param id        业务id
     * @param type      TpEventConstant
     * @param accountId 触发业务账号id
     * @param now       触发业务时间
     * @param finished  是否完成
     * @param siteId    站点id
     * @return
     */
    public static TrainingProjectEvent getInstance(Long id, Integer type, Long accountId, Date now, Long siteId, Boolean finished) throws Exception {
        if (id == null || type == null || accountId == null || now == null || siteId == null || finished == null) {
            throw new Exception("参数有误，请检查");
        }
        return new TrainingProjectEvent(id, type, accountId, now, null, null, null, finished, siteId, null);
    }


    /**
     * 考试业务发生用
     *
     * @param id
     * @param accountId
     * @param now
     * @param score
     * @return
     */
    public static TrainingProjectEvent getInstanceExam(Long id, Long accountId, Date now, Float score, Long siteId) throws Exception {
        if (id == null || accountId == null || now == null || score == null || siteId == null) {
            throw new Exception("参数有误，请检查");
        }
        return new TrainingProjectEvent(id, TpActivityType.TYPE_EXAM, accountId, now, score, null, null, null, siteId, null);
    }

    /**
     * 报名业务发生用
     *
     * @param id
     * @param accountId
     * @param now
     * @param trainingProjectId
     * @return
     */
    public static TrainingProjectEvent getInstanceEnroll(Long id, Long accountId, Date now, Long trainingProjectId, Long siteId) throws Exception {
        if (id == null || accountId == null || now == null || trainingProjectId == null || siteId == null) {
            throw new Exception("参数有误，请检查");
        }
        return new TrainingProjectEvent(id, TpActivityType.TYPE_ENROLL, accountId, now, null, trainingProjectId, null, null, siteId, null);
    }


    /**
     * 课程业务发生用
     *
     * @param id
     * @param accountId
     * @param now
     * @param seconds
     * @param finished
     * @returnf
     */
    public static TrainingProjectEvent getInstanceCourse(Long id, Long accountId, Date now, Long seconds, Boolean finished, Long siteId) throws Exception {
        if (id == null || accountId == null || now == null || seconds == null || finished == null || siteId == null) {
            throw new Exception("参数有误，请检查");
        }
        return new TrainingProjectEvent(id, TpActivityType.TYPE_COURSE, accountId, now, null, null, seconds, finished, siteId, null);
    }

    /**
     * 课程业务发生用  增加了补发字段
     *
     * @param id
     * @param accountId
     * @param now
     * @param seconds
     * @param finished
     * @returnf
     */
    public static TrainingProjectEvent getInstanceCourse(Long id, Long accountId, Date now, Long seconds, Boolean finished, Long siteId, Integer isCustom) throws Exception {
        if (id == null || accountId == null || now == null || seconds == null || finished == null || siteId == null || isCustom == null) {
            throw new Exception("参数有误，请检查");
        }
        return new TrainingProjectEvent(id, TpActivityType.TYPE_COURSE, accountId, now, null, null, seconds, finished, siteId, isCustom);
    }

    /**
     * 课程业务发生用 增加了补发、分数字段
     *
     * @param id
     * @param accountId
     * @param now
     * @param seconds
     * @param finished
     * @returnf
     */
    public static TrainingProjectEvent getInstanceCourse(Long id, Long accountId, Date now, Long seconds, Boolean finished, Long siteId, Integer isCustom,Float courseScore) throws Exception {
        if (id == null || accountId == null || now == null || seconds == null || finished == null || siteId == null) {
            throw new Exception("参数有误，请检查");
        }
        return new TrainingProjectEvent(id, TpActivityType.TYPE_COURSE, accountId, now, courseScore, null, seconds, finished, siteId, isCustom);
    }


    /**
     * 考试业务发生用
     * 已过时
     *
     * @param id
     * @param type
     * @param accountId
     * @param now
     * @param score
     * @return
     */
    @Deprecated
    public static TrainingProjectEvent getInstanceExam(Long id, Integer type, Long accountId, Date now, Float score, Long siteId) throws Exception {
        return getInstanceExam(id, accountId, now, score, siteId);
    }

    /**
     * 报名业务发生用
     * 已过时
     *
     * @param id
     * @param type
     * @param accountId
     * @param now
     * @param trainingProjectId
     * @return
     */
    @Deprecated
    public static TrainingProjectEvent getInstanceEnroll(Long id, Integer type, Long accountId, Date now, Long trainingProjectId, Long siteId) throws Exception {
        return getInstanceEnroll(id, accountId, now, trainingProjectId, siteId);
    }


}
