package com.yizhi.util.application.importexcel;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.util.StringUtils;

import au.com.bytecode.opencsv.CSVReader;

/**
 * Csv导入工具类
 * @author FanChunhui
 *
 */
 class CsvUtils {

	
	/**
	 * 将properties相对应的值设置到obj对象中最后add到list集合中<br>
	 * properties需要符合如下规则：<br>
	 * properties中值的顺序要与Excel中列相相应，否则值会设置错：<br>
	 * &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;excel:编号    姓名         年龄       性别<br>
	 * properties:id  name  age  sex<br>
	 * @param content 待解析的csv流
	 * @param properties 与Excel相对应的属性
	 * @return 返回对应数据
	 * @throws Exception
	 */
	static Object csvRead(InputStream content, String[] properties,int template){
		List<Object> resultList = new ArrayList<Object>(); // 初始化结果
		List<String[]> strs = new ArrayList<>();
		CSVReader csvReader;
		try {
			csvReader = new CSVReader(new InputStreamReader(content,"GBK"));
			strs = csvReader.readAll();
			for (int i = 0; i < strs.size(); i++) {
				if (i == 0) {
					continue;
				}else if((template == 1 && i <= 1) || (template == 2 && i <= 2)){
					continue;
				}
				String[] row = strs.get(i);
				resultList.add(readCell(row, properties));
			}

			csvReader.close(); 
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}  
		return resultList;
	}

	/**
	 * 用来获取每一行数据
	 * @param row 所有的行
	 * @param properties 用于对应Excel的配置
	 * @return 返回相对应数据
	 * @throws Exception
	 */
	private static Object readCell(String[] row, String[] properties){
		Map<String, String> result = new HashMap<>();
		for (int i = 0; i < row.length; i++) {
			String cellValue = row[i];
			try {
				if (!StringUtils.isEmpty(cellValue)) {
					result.put(properties[i], cellValue);
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return result;
	}
}
