package com.yizhi.util.application.importexcel;

import java.io.InputStream;


/**
 * ExcelCSV导入工具类入口
 * 根据传入文件类型判断调用导入方案
 * @author FanChunhui
 *
 */
public class ReadExcel {
	
	/**
	 * 解析Excel和CSV
	 * @param fileName 文件名
	 * @param fileType	文件类型
	 * @param content	导入的流文件
	 * @param properties	跟Excel对应的内容
	 * @param template	判断是否是特殊Excel 1为试题导入 2为问题导入
	 * @return
	 */
	public static Object parse(String fileName,String fileType,InputStream content,String[] properties,int template){
		Object object = new Object();
		if ("xls".equals(fileType) || "xlsx".equals(fileType)) {
			try {
				object = ExcelUtils.excelRead(content, properties, template);
				System.out.println(object.toString());
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}else if("csv".equals(fileType)){
			try {
				object = CsvUtils.csvRead(content, properties,template);
				System.out.println(object.toString());
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		return object;
	}

}
