package com.yizhi.util.application.page;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 分页信息
 */
@Data
@ApiModel(value = "page", description = "分页信息")
public class PageParam<T> {
	/**
	 * 记录总数
	 */
	@ApiModelProperty(value ="记录总数")
	private Integer pageRecords;
	/**
	 * 总页数
	 */
	@ApiModelProperty(value ="总页数")
	private Integer pageTotal;
	/**
	 * 当前页
	 */
	@ApiModelProperty(value = "当前页")
	private Integer pageNo;
	/**
	 * 每页记录数
	 */
	@ApiModelProperty(value = "每页记录数")
	private Integer pageSize;

	/**
	 * 排序字段
	 */
	@ApiModelProperty(value = "排序字段")
	private String pageSortField;
	/**
	 * 排序类型:asc升序  desc降序
	 */
	@ApiModelProperty(value = "排序类型:asc升序  desc降序")
	private String pageSortType;
	
}
