package com.yizhi.util.application.pdf;

import org.icepdf.core.exceptions.PDFException;
import org.icepdf.core.exceptions.PDFSecurityException;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.GraphicsRenderingHints;

import javax.imageio.ImageIO;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;

public class Pdf2Png {

	/*
	 * 设置icepdf系统属性
	 */
	static {
		Defs.setProperty("java.awt.headless", true);
		Defs.setProperty("org.icepdf.core.scaleImages", false);
		Defs.setProperty("org.icepdf.core.paint.disableAlpha", true);
	}
    /**
     * pdf转pdf(scale 默认1.0)
     * @param pdfPath pdf路径
     * @param outputFilePath 输出图片路径
     * @param endPage 截取到n页结束
     * @param filename 文件名
     * @throws InterruptedException
     * @throws PDFException
     * @throws PDFSecurityException
     * @throws IOException
     */
    public static boolean convert(String pdfPath, String outputFilePath,int endPage,String filename)
            throws InterruptedException, PDFException, PDFSecurityException, IOException {
        return convert(pdfPath, outputFilePath,1.0f,endPage,filename);
    }

    /**
     * pdf转pdf
     * @param pdfPath pdf路径
     * @param outputFilePath 输出图片路径
     * @param scale 放大比例 （放大比例越大越清晰）
     * @param endPage 截取到n页结束
     * @param filename 文件名
     * @throws InterruptedException
     * @throws PDFException
     * @throws PDFSecurityException
     * @throws IOException
     */
    public static boolean convert(String pdfPath, String outputFilePath,float scale,int endPage,String filename)
            throws InterruptedException, PDFException, PDFSecurityException, IOException {

        if (createDirectory(outputFilePath)) {

            Document document=new Document();
            document.setFile(pdfPath);

            int pages = document.getNumberOfPages();
            if(endPage > 0) {//大于0则打印具体页数
                if(endPage<pages) {
                    pages = endPage;
                }
            }

            float scaleIn = 1.5f;//缩放比例
            float rotationIn = 0f;//旋转角度

            for (int i = 0; i < pages; i++) {
                BufferedImage image = (BufferedImage)
                        document.getPageImage(i,
                                GraphicsRenderingHints.PRINT,
                                Page.BOUNDARY_TRIMBOX, rotationIn, scaleIn);
                RenderedImage rendImage = image;

                String imgFilePathPrefix = outputFilePath+File.separator+filename+(i + 1)+".png";

                File file = new File(imgFilePathPrefix);
                ImageIO.write(rendImage, "png", file);

                image.flush();
                document.dispose();
            }
        }
        return true;
    }

    private static  boolean createDirectory(String folder) {
        File dir = new File(folder);
        if (dir.exists()) {
            return true;
        } else {
            return dir.mkdirs();
        }
    }
}
