package com.yizhi.core.application.cache;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 18:15 2018/3/21
 * @Modified By
 */
public class CacheNamespace {


    /**
     * 缓存的key
     */
    public static final String REDIS_COMPANIES = "system.companies";
    public static final String REDIS_COMPANY_ORGS = "system.company.orgs";
    public static final String REDIS_SITES = "system.sites";
    /**
     * :companyCode -- siteCode
     */
    public static final String REIDS_COMPANY_SITE_ORGS = "system.site.orgs:";
    /**
     * :companyCode -- siteCode
     */
    public static final String REIDS_COMPANY_SITE_ORGIDS = "system.site.orgIds:";
    /**
     * :companyCode -- sitecode/accountId
     */
    public static final String REDIS_AUTHZ_MANAGE_COMPANY_MANAGERIDS = "system.authz.account:managerIds:";
    /**
     * :companyCode -- sitecode/accountId
     */
    public static final String REDIS_AUTHZ_MANAGE_COMPANY_ORGIDS = "system.authz.account:orgIds:";
    /**
     * :companyCode -- accountId
     */
    public static final String REDIS_AUTHZ_MANAGE_COMPANY_ACCOUNT_ACCESS_SITE = "system.authz.account.manage.access:";
    /**
     * :companyCode -- accountId
     */
    public static final String REDIS_AUTHZ_FRONT_COMPANY_ACCOUNT_ACCESS_SITE = "system.authz.account.front.access:";

    public static final String REDIS_HASH_SEPARATOR = "/";

    public static final String REDIS_SENSITIVE_WORD_INFO = "system.all.sensitive.word";
    public static final String REDIS_USERS_ROLE_RESOURCES = "users.role.resources";

    /**
     * 已经完成的计划 trainingProjectId   hash
     * eg:  tp:plan:finished:{accountId} -- {trainingProjectId} -- 1
     */
    public static final String TP_TRAININGPROJECT_FINISHED = "tp:trainingProject:finished:";

    /**
     * 已经完成的计划 planId   hash
     * eg:  tp:plan:finished:{accountId} -- {planId} -- 1
     */
    public static final String TP_PLAN_FINISHED = "tp:plan:finished:";

    /**
     * 已经完成的活动 relationId   hash
     * eg:  tp:activity:finished:{accountId} -- {relationId} -- 1
     */
    public static final String TP_ACTIVITY_FINISHED = "tp:activity:finished:";

    /**
     * 未通过的活动 relationId   hash
     * eg:  tp:activity:unfinished:{accountId} -- {relationId} -- 0
     */
    public static final String TP_ACTIVITY_UNFINISHED = "tp:activity:unfinished:";

    /**
     * 已经点击过的活动 relationId   hash
     * eg:  tp:activity:unfinished:{accountId} -- {relationId} -- 1
     */
    public static final String TP_ACTIVITY_CLICKED = "tp:activity:clicked:";

    /**
     * 已经完成的专辑课程 relationId   hash
     * eg:  al:activity:finished:{accountId}:{albumId} -- {relationId} -- 1
     */
    public static final String AL_ACTIVITY_FINISHED = "al:activity:finished:";

    /**
     * 未完成的专辑课程 relationId   hash
     * eg:  al:activity:unfinished:{accountId}:{albumId} -- {relationId} -- 0
     */
    public static final String AL_ACTIVITY_UNFINISHED = "al:activity:unfinished:";


    /**
     * 课程 学时
     * eg:  course:study:hour:{siteId} - {{accountId}-{courseId}} - 100
     */
    public static final String COURSE_STUDY_HOUR = "course:study:hour:";

    public static final String ORG_INDEX_INIT_KEY = "org:index:init:key";

    /**
     * 语种 companyId string   获取语种的列表
     * eg:  site:language:companyId
     */
    public static final String SITE_LANGUAGE = "site:language:";
    /**
     * 国际化  hash  获取语种对应的翻译Json
     * eg:  site:language:international:终端类型 -- languageCode
     */
    public static final String SITE_LANGUAGE_INTERNATIONAL_WORD = "site:language:international:";

    /**
     * 国际化  hash  获取用户选取的语种
     * eg:  site:language:student:select:accountId -- languageCode
     */
    public static final String SITE_LANGUAGE_STUDENT_SELECT = "site:language:student:select";
    /**
     * 配置的专区 key
     * site_student:siteId
     */
    public static final String SITE_STUDENT_RECORDS = "site_student:";

    /**
     * 记录学员最后一次登录的站点信息
     * key:site_student_last_login_records   item:accountId
     */
    public static final String SITE_STUDENT_LAST_LOGIN_RECORDS = "site_student_last_login_records";

    /**
     * 保存站点的唯一code
     */
    public static final String SITE_EXIST_LOGIN_CODE = "site_exist_login_code:";
}




