package com.yizhi.core.application.context;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 上下文信息
 *
 * @author scott
 */
@Data
public class RequestContext implements Serializable {


    private static final long serialVersionUID = 1L;

    /*
     * 公司id
     */
    private Long companyId;

    /*
     * 公司code
     */
    private String companyCode;

    /*
     * 公司名称
     */
    private String companyName;

    /*
     * 访问站点id
     */
    private Long siteId;

    /*
     * 访问站点id
     */
    private String siteCode;

    /*
     * 访问站点id
     */
    private String siteName;

    /*
    站点类型(1:子站点2:业务站点)
     */
    private Integer siteType;

    /*
    站点归属(当站点类型=1:子站点时，关联组织Id，当站点类型=2:业务站点时，关联用户组id)
     */
    private Long siteMember;

    /*
     * 账号所属部门id
     */
    private Long orgId;

    /*
     * 账号所属部门名称
     */
    private String orgName;

    /*
     * 当前登陆账号id
     */
    private Long accountId;
    /*
     * 当前登陆账号名称
     */
    private String accountName;
    /*
     * 当前登陆账号全名称
     */
    private String accountFullName;
    /**
     * 用户头像信息
     */
    private String headPortrait;

    /*
     * 请求id
     */
    private String requestId;

    /**
     * 是否管理员权限
     */
    private boolean admin;

    /**
     * 管理的组织ID
     */
    private List<Long> orgIds;

    /*
     * 授权码,企业直接访问api接口（定制访问）
     */
    private String authCode;


    /**
     * 用户所在的用户组，用户id
     */
    private List<Long> relationIds;

    /**
     * 分级授权可管理用户 id 集合
     */
    private List<Long> managerIds;

    private String requestType;

    private String remoteAddr;
    /**
     * 语言类型
     */
    private String languageType;
    /**
     * 是否为社群管理员--只要角色管理了社群（menu表中is_community=true）的菜单
     */
    private Boolean isCommunityManager = false;

    /**
     * 为社群管理员且只有社群菜单权限没有其他的菜单
     */
    private Boolean isOnlyCommunity = false;

    public Long getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Long getSiteId() {
        return siteId;
    }

    public void setSiteId(Long siteId) {
        this.siteId = siteId;
    }

    public String getSiteName() {
        return siteName;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getHeadPortrait() {
        return headPortrait;
    }

    public void setHeadPortrait(String headPortrait) {
        this.headPortrait = headPortrait;
    }

    public String getRequestId() {
        return requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean isAdmin() {
        return admin;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public List<Long> getOrgIds() {
        return orgIds;
    }

    public void setOrgIds(List<Long> orgIds) {
        this.orgIds = orgIds;
    }

    public List<Long> getRelationIds() {
        return relationIds;
    }

    public void setRelationIds(List<Long> relationIds) {
        this.relationIds = relationIds;
    }

    public String getAccountFullName() {
        return accountFullName;
    }

    public void setAccountFullName(String accountFullName) {
        this.accountFullName = accountFullName;
    }

    public Integer getSiteType() {
        return siteType;
    }

    public void setSiteType(Integer siteType) {
        this.siteType = siteType;
    }

    public Long getSiteMember() {
        return siteMember;
    }

    public void setSiteMember(Long siteMember) {
        this.siteMember = siteMember;
    }

    public String getCompanyCode() {
        return companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }

    public String getAuthCode() {
        return authCode;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public String getSiteCode() {
        return siteCode;
    }

    public void setSiteCode(String siteCode) {
        this.siteCode = siteCode;
    }

    public List<Long> getManagerIds() {
        return managerIds;
    }

    public void setManagerIds(List<Long> managerIds) {
        this.managerIds = managerIds;
    }

    public String getRequestType() {
        return requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public enum RequestType {
        MANAGE,
        STUDENT
    }

    public String getLanguageType() {
        return languageType;
    }

    public void setLanguageType(String languageType) {
        this.languageType = languageType;
    }
}
