package com.yizhi.core.application.context;

import com.yizhi.util.application.constant.GlobalConstant;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.stereotype.Component;

import javax.servlet.*;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/**
 * 设置上下文信息过滤器
 * @author scotthu
 *
 */
@Component("cloudRequestContextFilter1")
@ServletComponentScan
@WebFilter(urlPatterns = "/*",filterName = "cloudRequestContextFilter")
public class RequestContextFilter implements Filter {

	private static Logger logger = LoggerFactory.getLogger(RequestContextFilter.class);

	/**
	 * 回收
	 */
	@Override
	public void destroy() {

	}

	@Override
	public void init(FilterConfig filterConfig) throws ServletException {
		logger.info("cloud request context filter inited");
	}

	@Override
	public void doFilter(ServletRequest servletRequest, ServletResponse response, FilterChain chain)
			throws IOException, ServletException {
		HttpServletRequest request = (HttpServletRequest) servletRequest;
		RequestContext ctx = new RequestContext();
		ctx.setRemoteAddr(request.getRemoteAddr());
		// 请求id
		String requestId = request.getHeader(GlobalConstant.REQUEST_ID);
		if(StringUtils.isNotEmpty(requestId)) {
			ctx.setRequestId(requestId);
		} else {
			ctx.setRequestId(UUID.randomUUID().toString());
		}
		// 设置企业id
		ctx.setCompanyId(getHeaderLong(request,GlobalConstant.COMPANY_ID));
		// 设置企业code
		ctx.setCompanyCode(request.getHeader(GlobalConstant.COMPANY_CODE));
		// 设置企业名称
		ctx.setCompanyName(URLDecoder.decode(StringUtils.trimToEmpty(request.getHeader(GlobalConstant.COMPANY_NAME)),"UTF-8"));
		// 设置访问站点id
		ctx.setSiteId(getHeaderLong(request,GlobalConstant.SITE_ID));

		// 设置访问站点CODE
		ctx.setSiteCode(StringUtils.trimToEmpty(request.getHeader(GlobalConstant.SITE_CODE)));

		// 设置访问站点Name
		ctx.setSiteName(URLDecoder.decode(StringUtils.trimToEmpty(request.getHeader(GlobalConstant.SITE_NAME)),"UTF-8"));
		// 设置用户所属组织id
		ctx.setOrgId(getHeaderLong(request,GlobalConstant.ORG_ID));
		// 设置用户所属组织Name
		ctx.setOrgName(URLDecoder.decode(StringUtils.trimToEmpty(request.getHeader(GlobalConstant.ORG_NAME)),"UTF-8"));

		// 设置用户id
		ctx.setAccountId(getHeaderLong(request,GlobalConstant.ACCOUNT_ID));
		// 设置用户Name
		ctx.setAccountName(URLDecoder.decode(StringUtils.trimToEmpty(request.getHeader(GlobalConstant.ACCOUNT_NAME)),"UTF-8"));
		// 设置用户全Name
		ctx.setAccountFullName(URLDecoder.decode(StringUtils.trimToEmpty(request.getHeader(GlobalConstant.ACCOUNT_FULL_NAME)),"UTF-8"));
		// 设置用户头像
		ctx.setHeadPortrait(URLDecoder.decode(StringUtils.trimToEmpty(request.getHeader(GlobalConstant.HEAD_PORTRAIT)),"UTF-8"));
		ctx.setRequestType(URLDecoder.decode(StringUtils.trimToEmpty(request.getHeader(GlobalConstant.REQUEST_TYPE)),"UTF-8"));

		// 是否是管理(y:是超级管理员；n表示不是管理员）
		//ctx.setAdmin(StringUtils.equalsIgnoreCase(GlobalConstant.ADMIN_FLG,"y"));
		ctx.setAdmin(Boolean.valueOf(request.getHeader(GlobalConstant.ADMIN_FLG)));
		/*ctx.setSiteType(getHeaderLong(request,GlobalConstant.SITE_TYPE).intValue());
		ctx.setSiteMember(getHeaderLong(request,GlobalConstant.SITE_MEMBER));*/
		ctx.setSiteMember(getHeaderLong(request,GlobalConstant.SITE_MEMBER));
		// 授权码
		ctx.setAuthCode(StringUtils.trimToEmpty(request.getHeader(GlobalConstant.AUTH_CODE)));
		// 用户所属的组织
		String orgIds = request.getHeader(GlobalConstant.ORG_IDS);
		if(StringUtils.isNotBlank(orgIds)){
			String[] orgIdsArr = StringUtils.split(orgIds,",");
			if(orgIdsArr != null && orgIdsArr.length>0){
				List<Long> orglongList = new ArrayList<>();
				for(String item : orgIdsArr){
					orglongList.add(Long.valueOf(item));
				}
				ctx.setOrgIds(orglongList);
			}
		}else{
			ctx.setOrgIds(new ArrayList<>());
		}

		String managerIds = request.getHeader(GlobalConstant.MANAGER_IDS);
		if(StringUtils.isNotBlank(managerIds)){
			String[] managerIdsArr = StringUtils.split(managerIds,",");
			if(managerIdsArr != null && managerIdsArr.length>0){
				List<Long> managerlongList = new ArrayList<>();
				for(String item : managerIdsArr){
					managerlongList.add(Long.valueOf(item));
				}
				ctx.setManagerIds(managerlongList);
			}
		}else{
			ctx.setManagerIds(new ArrayList<>());
		}

		String relationIds = request.getHeader(GlobalConstant.RELATION_IDS);
		if(StringUtils.isNotBlank(relationIds)){
			String[] relationIdsArr = StringUtils.split(relationIds,",");
			if(relationIdsArr != null && relationIdsArr.length>0){
				List<Long> longList = new ArrayList<>();
				for(String item : relationIdsArr){
					longList.add(Long.valueOf(item));
				}
				ctx.setRelationIds(longList);
			}
		}
		String languageType = request.getHeader(GlobalConstant.LANGUAGE_TYPE);
		if (languageType != null) {
			//设置语言类型
			ctx.setLanguageType(StringUtils.trimToEmpty(languageType));
		}
		ContextHolder.set(ctx);
		//logger.info("**********************************************操作上下文已设置：{}******************************************************", JSON.toJSONString(ctx));
		chain.doFilter(request, response);
		
	}

	private static Long getHeaderLong(HttpServletRequest request,String key){
		String headerVal = request.getHeader(key);
		if(StringUtils.trimToEmpty(headerVal).equals(StringUtils.EMPTY)){
			return 0L;
		}
		Long retVal = 0L;
		try {
			retVal = Long.valueOf(headerVal);
		} catch (NumberFormatException e) {
			logger.info("上下文转换异常，key="+key+", 值="+(StringUtils.isEmpty(headerVal)?"空值":headerVal));
			retVal = 0L;
		}
		return retVal;

	}

}
