/**
 * 
 */
package com.yizhi.core.application.exception;

import java.io.IOException;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.hystrix.exception.HystrixBadRequestException;

import feign.Response;
import feign.Util;
import feign.codec.ErrorDecoder;

/**
 * Feign调用异常解码类
 * @author scotthu
 *
 * @date 2018年2月28日
 */
@Configuration
public class FeignClientExceptionErrorDecoder implements ErrorDecoder {
	
	private static final Logger logger = LoggerFactory.getLogger(FeignClientExceptionErrorDecoder.class);
	private final ErrorDecoder delegate = new ErrorDecoder.Default();

        @Override
        public Exception decode(String methodKey, Response response) {
        	 // Only decode 4xx errors.
            if (response.status() >= 500 || response.status() < 400) {
                return delegate.decode(methodKey, response);
            }
            
    		ObjectMapper om = new ObjectMapper();
    		FeignResponse wrapResponse;
    		Exception exception = null;
            try {
            	wrapResponse = om.readValue(Util.toString(response.body().asReader()),FeignResponse.class);
            	//避免hystrix对业务异常进行计数,从而触发熔断
            	exception = new HystrixBadRequestException(wrapResponse.getMessage());
            	logger.error("Feign调用异常：{}", wrapResponse);
    		} catch (IOException ex) {
    			logger.error(ex.getMessage(), ex);
    		}
            
    		return exception;
    	}
    }