
package com.yizhi.core.application.file.exp;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

import com.yizhi.core.application.file.constant.FileConstant;
import com.yizhi.core.application.file.domain.FileInfo;
import com.yizhi.core.application.log.TaskLogEvent;
import com.yizhi.core.application.file.util.OssUpload;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.yizhi.core.application.file.domain.Template;
import com.yizhi.core.application.file.domain.TemplateColumn;
import com.yizhi.util.application.clazz.ClassUtil;

/**
 * CSV导出模板实现类
 * @author yinyuyan 2018/01/23
 *
 */
public class CsvExportor<T> extends AbstractExporter<T>{
	private static final Logger logger = LoggerFactory.getLogger(CsvExportor.class);
	
	private String httpProxyUrl;
	private Integer httpProxyPort;
	
	public CsvExportor(HttpServletResponse response,Template template,List<T> data) {
		super(response,template, data);
	}
	public CsvExportor(Template template,List<T> data) {
		super(template,data);
	}
	
	public CsvExportor(HttpServletResponse response,Template template,List<T> data, String httpProxyUrl, Integer httpProxyPort) {
		super(response,template, data);
		this.httpProxyUrl = httpProxyUrl;
		this.httpProxyPort = httpProxyPort;
	}
	public CsvExportor(Template template,List<T> data, String httpProxyUrl, Integer httpProxyPort) {
		super(template,data);
		this.httpProxyUrl = httpProxyUrl;
		this.httpProxyPort = httpProxyPort;
	}
	
	@Override
	public FileInfo render() {
		publishTaskEvent(TaskLogEvent.working(taskContext,"csv导出开始"));
		FileInfo fileInfo=new FileInfo();
		fileInfo.setFileType(template.getFileType());
		//文件名
		String fileName = String.valueOf(System.currentTimeMillis()).concat(".csv");
		fileInfo.setFileName(fileName);
		BufferedWriter bw =null;  
		FileOutputStream out = null;  
        OutputStreamWriter osw = null;
        String path = null;
		try {
			if(template.getBrowserExport()){//浏览器导出
				response.setContentType("application/csv");  
		        response.setHeader("Content-Disposition", "attachment; filename="+fileName);
		        bw = new BufferedWriter(response.getWriter());
			}else{
				path = new StringBuffer().append(FileConstant.SAVE_PATH).append(File.separator).append(fileName).toString();
				out = new FileOutputStream(new File(path));  
	            osw = new OutputStreamWriter(out, "UTF-8");   
	            bw = new BufferedWriter(osw);   
			}
			List<List<String>> lines=getCsvLines(template,data);
            for (List<String> line : lines) {  
            	StringBuffer sb = new StringBuffer();  
                
                for (int i = 0; i < line.size(); i++) {  
                    String value = line.get(i);  
                    if (value == null) {  
                    	value = "";  
                    }  
                    sb.append("\"").append(value.replaceAll("\"", "\"\"")).append("\",");  
                }  
                  
                bw.write(sb.deleteCharAt(sb.length() - 1).toString());  
                bw.newLine(); 
            }
            if(!template.getBrowserExport()){
            	//阿里云返回url
            	String upLoadUrl = null;
				if(!StringUtils.isBlank(httpProxyUrl) && httpProxyPort != null && httpProxyPort != 0){
					upLoadUrl = OssUpload.upload(path, fileName, httpProxyUrl, httpProxyPort);//path, fileName
				} else {
					upLoadUrl = OssUpload.upload(path, fileName);//path, fileName
				}
				publishTaskEvent(TaskLogEvent.success(taskContext,"成功导入数据", upLoadUrl));
				File file=new File(path);
				file.delete();
            }
		}catch (Exception e) {  
    		publishTaskEvent(TaskLogEvent.fail(taskContext,"csv导出异常"));
	           logger.error("csv导出异常",e); 
	    }finally {
	    	if (null != bw) {
	    	    try {   
	    	    	bw.close();   
	            } catch (IOException e) {  
	         	   logger.error("关闭bw异常",e);  
	            } 
	    	}   
    	    if (null != osw) {  
                try {  
                    osw.close();  
                    osw = null;  
                } catch (IOException e) {  
                	logger.error("关闭osw异常",e);    
                }  
            }  
            if (null != out) {  
                try {  
                    out.close();  
                    out = null;  
                } catch (IOException e) {  
                	logger.error("关闭out异常",e);   
                }  
            }  
		}        
        return fileInfo;
	}
	/**
	 * 获取表头信息和行数据
	 * @param template
	 * @param data
	 * @return
	 */
	private List<List<String>> getCsvLines(Template template,List<T> data){
		List<List<String>> lines=new ArrayList<>();
		List<TemplateColumn> columns=template.getColumns();
		List<String> lineHead=new ArrayList<>();
		for(int i=0;i<columns.size();i++){
		    lineHead.add(columns.get(i).getColumnName());
		}
		lines.add(lineHead);
		if(CollectionUtils.isNotEmpty(data)){
		    for(int j=0;j<data.size();j++){
		    	T t =data.get(j);
		    	List<String> line=new ArrayList<>();
		    	for(int m=0;m<columns.size();m++){
		    		TemplateColumn templateColumn=columns.get(m);
		    		line.add(ClassUtil.invokeMethod(t, templateColumn.getColumn()));
		    	}
		    	lines.add(line);
		    }
		}
		return lines;
	}
}
