package com.yizhi.core.application.file.task;

/**
 * 异步线程
 * @author mei
 *
 * </br>泛型定义：T返回类型     V参数类型
 */
public abstract class TaskThread<T, V> implements Runnable {
	private AbstractDefaultTask<T, V> task;
	private V objParam;
	
	//异常回调方法
	protected abstract void callException(Exception e);
	
	/**
	 * 异步执行参数
	 * @param task 实现类
	 * @param objParam 参数
	 */
	TaskThread(AbstractDefaultTask<T, V> task, V objParam){
		this.task = task;
		this.objParam = objParam;
	}

	@Override
	public void run() {
		try{
			task.execute(objParam);
		} catch(Exception e){
			callException(e);
		}
	}
}
