package com.yizhi.core.application.file.util;

import io.minio.MinioClient;
import io.minio.errors.InvalidEndpointException;
import io.minio.errors.InvalidPortException;
import lombok.Data;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Created by lu.wu to date 2020/8/24.
 */
@Data
@Configuration
@ConfigurationProperties(prefix = "spring.minio")
@ConditionalOnExpression("${spring.minio.enabled:true}")
public class MinioConfig {

    private String url;

    private int port;

    private String accessKey;

    private String secretKey;

    private String switchFlag; //转换开关

    private boolean secure;


    @Bean
    public MinioClient minioClient() throws InvalidEndpointException, InvalidPortException {
        MinioClient minioClient = new MinioClient(url, port, accessKey, secretKey,secure);
        return minioClient;
    }


}
