package com.yizhi.application.discovery;

import com.nepxion.discovery.plugin.strategy.zuul.filter.ZuulStrategyRouteFilter;
import com.yizhi.core.application.cache.RedisCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

/**
 * @ClassName DiscoveryConfig
 * @Description TODO
 * @Author shengchenglong
 * @DATE 2020/12/1 17:26
 * @Version 1.0
 */
@Configuration
public class DiscoveryConfig {

    @Autowired
    private DiscoveryProperties discoveryProperties;

    @Autowired
    private RedisCache redisCache;

    @Bean
    public ContainerCache containerCache() {
        return new ContainerCache(discoveryProperties, redisCache);
    }

    @Bean
    public ZuulStrategyRouteFilter zuulStrategyRouteFilter() {
        return new MyZuulStrategyRouteFilter(discoveryProperties, containerCache());
    }

}
