package com.yizhi.application.filter;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.springframework.cloud.netflix.zuul.filters.support.FilterConstants;

import java.util.HashMap;
import java.util.Map;

/**
 * @ClassName FilterConstant
 * @Description TODO
 * @Author shengchenglong
 * @DATE 2021/1/12 16:36
 * @Version 1.0
 */
public class FilterConstant {

    private static final Map<Class, FilterParam> map = new HashMap<>();

    static {
        map.put(EntryFilter.class, new FilterParam(Integer.MIN_VALUE + 2, FilterConstants.PRE_TYPE));
        map.put(ErrorFilter.class, new FilterParam(Integer.MIN_VALUE, FilterConstants.ERROR_TYPE));
        map.put(InternationalZuulFilter.class, new FilterParam(Integer.MIN_VALUE + 1, FilterConstants.POST_TYPE));
        map.put(LogPostFilter.class, new FilterParam(Integer.MAX_VALUE, FilterConstants.POST_TYPE));
        map.put(LogPreFilter.class, new FilterParam(Integer.MIN_VALUE, FilterConstants.PRE_TYPE));
        map.put(SiteProtectZuulFilter.class, new FilterParam(Integer.MIN_VALUE + 1, FilterConstants.PRE_TYPE));
    }

    public static String type(Class clazz) {
        return map.get(clazz).getType();
    }

    public static Integer order(Class clazz) {
        return map.get(clazz).getOrder();
    }


    @Data
    @AllArgsConstructor
    public static class FilterParam {

        private Integer order;

        private String type;
    }

}
