package com.yizhi.application;

import com.yizhi.core.application.log.LogQueue;
import org.springframework.amqp.core.Queue;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;


@SpringBootApplication(exclude = {RabbitAutoConfiguration.class})
@EnableDiscoveryClient
@ComponentScan(basePackages = {"com.yizhi"})
public class LogApplication {
	
	@Bean
    public Queue createOperateLogQueue() {
        return new Queue(LogQueue.OPERATE_LOG_QUEUE,true,false,false);
    }
	
	@Bean
	public Queue createTaskLogQueue() {
		return new Queue(LogQueue.TASK_LOG_QUEUE,true,false,false);
	}
	
	@Bean
	public Queue createTaskLogDetailQueue() {
		return new Queue(LogQueue.TASK_LOG_DETAIL_QUEUE,true,false,false);
	}
	
	@Bean
	public Queue createBatchTaskLogDetailQueue() {
		return new Queue(LogQueue.BATCH_TASK_LOG_DETAIL_QUEUE,true,false,false);
	}
	
	public static void main(String[] args) {
		SpringApplication.run(LogApplication.class, args);
	}

	
}
