package com.yizhi.application.domain;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author scotthu
 * @date 2018年3月19日
 */
@Data
public class TaskLog implements Serializable {

	/**
	 *
	 */
	private static final long serialVersionUID = 489476911287542034L;

	/**
	 * 任务日志id
	 */
	Long id;

	/**
	 * 任务名称
	 */
	String name;
	/**
	 * 任务提交人id
	 */
	Long submitterId;
	/**
	 * 任务状态
	 */
	Integer status;
	/**
	 * 任务结果
	 */
	String result;
	/**
	 * 下载路径
	 */
	String url;
	/**
	 * 任务提交时间
	 */
	Date submitTime;
	/**
	 * 创建时间
	 */
	Date createTime;

	/**
	 * 修改时间
	 */
	Date updateTime;
	/**
	 * 序号
	 */
	String serialNo;
	/**
	 * 公司id
	 */
	Long companyId;
	/**
	 * 站点id
	 */
	Long siteId;

	/**
	 * 创建人id （不要修改字段名）该字段必须要，分级授权需要
	 */
	Long createById;

	public TaskLog() {

	}

	public TaskLog(Long id, String status, String result) {
		this.id = id;
		this.updateTime = new Date();
	}
}
