package com.yizhi.application.handle;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;

import com.alibaba.fastjson.JSON;
import com.yizhi.core.application.log.TaskLogEvent;
import com.yizhi.application.service.TaskLogService;
import com.yizhi.util.application.constant.QueueConstant;

@Configuration
@RabbitListener(queues = QueueConstant.TASK_LOG_QUEUE)
public class TaskLogListener {
	private static Logger log = LoggerFactory.getLogger(TaskLogListener.class);
	@Autowired
	TaskLogService taskLogService;

	@RabbitHandler
	public void saveLog(TaskLogEvent taskLogEvent) {
		log.info("taskLogEvent======"+JSON.toJSONString(taskLogEvent));
		try {
			taskLogService.add(taskLogEvent);
		} catch (Exception e) {
			log.error("任务监控日志插入异常",e);
		}		
	}
}
