package com.yizhi.application.service;

import java.util.List;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.log.TaskLogDetailEvent;
import com.yizhi.application.domain.TaskLogDetail;

/**
 * 异步任务日志详情服务接口
 * @author scotthu
 *
 * @date 2018年3月19日
 */
public interface TaskLogDetailService {
	
	/**
	 * 分页返回任务日志明细
	 * @param taskLogId 任务日志id
	 * @return 任务日志明细分页数据
	 */
	Page<TaskLogDetail> listDetails(TaskLogDetail taskLogDetail, Page<TaskLogDetail> page);
	/**
	 * 新增消息详情
	 * @param taskLogDetailEvent
	 */
	void addLogDetail(TaskLogDetailEvent taskLogDetailEvent);
	/**
	 * 批量增加消息详情
	 * @param details
	 */
	void batchAddLogDetail(List<TaskLogDetailEvent> details);
}
