package com.yizhi.application.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.yizhi.application.domain.TaskLogDetail;
import com.yizhi.application.mapper.TaskLogDetailMapper;
import com.yizhi.application.service.TaskLogDetailService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.core.application.log.TaskLogDetailEvent;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.orm.util.QueryUtil;


@Service
public class TaskLogDetailServiceImpl  extends ServiceImpl<TaskLogDetailMapper, TaskLogDetail> implements TaskLogDetailService {
	
	@Autowired
	IdGenerator idGenerator;
	
	private static Logger log = LoggerFactory.getLogger(TaskLogDetailServiceImpl.class);

	@Override
	public Page<TaskLogDetail> listDetails(TaskLogDetail taskLogDetail,Page<TaskLogDetail> page){
		//默认按创建时间排序
        page.setOrderByField("create_time");
        page.setAsc(false);
		return this.selectPage(page, QueryUtil.condition(taskLogDetail));
	}

	@Override
	public void addLogDetail(TaskLogDetailEvent taskLogDetailEvent) {
		TaskLogDetail taskLogDetail = new TaskLogDetail();		
		taskLogDetail.setId(idGenerator.generate());
		taskLogDetail.setLogId(taskLogDetailEvent.getLogId());
		taskLogDetail.setContent(taskLogDetailEvent.getContent());
		taskLogDetail.setCreateTime(new Date());
		this.insert(taskLogDetail);		
	}

	@Override
	public void batchAddLogDetail(List<TaskLogDetailEvent> details) {
		if(CollectionUtils.isNotEmpty(details)){
			List<TaskLogDetail> logDetails=new ArrayList<>();
			for(TaskLogDetailEvent detail:details){
				TaskLogDetail taskLogDetail = new TaskLogDetail();		
				taskLogDetail.setId(idGenerator.generate());
				taskLogDetail.setLogId(detail.getLogId());
				taskLogDetail.setContent(detail.getContent());
				taskLogDetail.setCreateTime(new Date());
				logDetails.add(taskLogDetail);
			}
			this.insertBatch(logDetails);
		}		
	}
}
