package com.yizhi.application.orm.tenant;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.baomidou.mybatisplus.annotations.TableName;
import com.yizhi.util.application.clazz.AnnotationClassLoader;
import com.yizhi.util.application.clazz.ClassUtil;

public class TenantEntityHolder {
	
	private static Logger log = LoggerFactory.getLogger(TenantEntityHolder.class);
	private final static Map<String,TenantType> entityTenantTypes = new  HashMap<String,TenantType>(32);
   
	public static void scan(String[] packageName){
		AnnotationClassLoader acl = new AnnotationClassLoader(packageName,null);
		Set<Class<?>> classes = null;
		try {
			classes = acl.getClassSet();
			for (Class<?> clz : classes) {
				String table=clz.getAnnotation(TableName.class)==null?
						null:clz.getAnnotation(TableName.class).value().toLowerCase();
							
				if(ClassUtil.existMethod(clz, "getSiteId"))
					entityTenantTypes.put(table, TenantType.SITE);
				else if(ClassUtil.existMethod(clz, "getCompanyId"))
					entityTenantTypes.put(table, TenantType.COMPANY);
			}
		} catch (Exception e) {
			log.error("扫描实体类过程中出现错误:" + e.getMessage());
			throw new RuntimeException("扫描实体类过程中出现错误:" + e.getMessage());
		}
	}
	
	public static TenantType getTenantType(String table) {
		return entityTenantTypes.get(table);
	}
}
