/**
 * 
 */
package com.yizhi.application.orm.util;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

import com.baomidou.mybatisplus.plugins.Page;

/**
 * @author scotthu
 *
 * @date 2018年3月12日
 */
@Component
public class DomainConverter<DO,VO> {
	
	private static Logger log = LoggerFactory.getLogger(DomainConverter.class);
	
	/**
	 * 实体类转换成VO
	 * @param entity
	 * @param clazz
	 * @return
	 */
	public VO toVO(DO entity,Class<VO> clazz ) {
		if(null==entity) return null;
		VO vo = null;
        try {
            vo = clazz.newInstance();
        } catch (Exception e) {
            log.error("初始化{}对象失败。", clazz, e);
        }
		BeanUtils.copyProperties(entity,vo);
		return vo;
	}
	
	/**
	 * VO转换成实体类
	 * @param vo
	 * @param clazz
	 * @return
	 */
	 
	public DO toDO(VO vo,Class<DO> clazz ) {
		if(null==vo) return null;
		DO entity = null;
        try {
        	entity = clazz.newInstance();
        } catch (Exception e) {
            log.error("初始化{}对象失败。", clazz, e);
        }
		BeanUtils.copyProperties(vo,entity);
		return entity;
	}
	
	/**
	 * 实体类列表转换成VO列表
	 * @param entities
	 * @param clazz
	 * @return
	 */
	public List<VO> toVOList(List<DO> entities,Class<VO> clazz){
		if(CollectionUtils.isEmpty(entities)) return null;
		List<VO> voList=new ArrayList<>();
		if(CollectionUtils.isEmpty(entities))
		      return voList;

		for(DO entity : entities){
				voList.add(toVO(entity,clazz));
		}
		
		return voList;
	}
	
	/**
	 * VO列表转换成实体类列表
	 * @param entities
	 * @param clazz
	 * @return
	 */
	public List<DO> toDOList(List<VO> entities,Class<DO> clazz){
		if(CollectionUtils.isEmpty(entities)) return null;
		List<DO> doList=new ArrayList<>();
		if(CollectionUtils.isEmpty(entities))
		      return doList;
		for(VO entity : entities){
				doList.add(toDO(entity,clazz));
		}		
		return doList;
	}
	
	/**
	 * 实体类分页信息转换成VO分页信息
	 * @param page
	 * @param clazz
	 * @return
	 */
	public Page<VO> toPageVO(Page<DO> page,Class<VO> clazz){
		if(null==page) return null;
		Page<VO> pageVO=new Page<>();
		try {
			BeanUtils.copyProperties(page, pageVO);
		} catch (Exception e) {
            log.error("初始化{}对象失败。", clazz, e);
        }
		pageVO.setRecords(toVOList(page.getRecords(),clazz));
		return pageVO;
	}
}
