package com.yizhi.system.application.constant;

/**
 * @Author: shengchenglong
 * @Date: 2018/3/23 11:27
 */
public interface AuthzConstant {

    // 企业组织结构redis key,
    String REDIS_COMPANY_STRUCTURE = "COMPANY_STRUCTURE";

    // 企业管理员角色code
    String ROLE_COMPANY_ADMIN = "company_admin";

    // 模块管理员 角色code 匹配
    String ROLE_MODULE_ADMIN_REGEX = "company_[\\s\\S]*_admin";

    /**
     * 1:默认站点
     */
    Integer SITE_TYPE_DEFAULT = 1;
    /**
     * 2:业务站点（关联管辖区）
     */
    Integer SITE_TYPE_SUB = 2;

    /**
     * 成员类型(1:用户2:部门)
     */
    Integer GROUP_MEMBER_TYPE_ACCOUNT = 2;

    /**
     * 成员类型(1:用户2:部门)
     */
    Integer GROUP_MEMBER_TYPE_ORG = 1;

    /**
     * 账号类型：前端学员
     */
    Integer ACCOUNT_TYPE_FRONT = 1;
    /**
     * 账号类型：前端学员 和 后端管理员
     */
    Integer ACCOUNT_TYPE_FRONT_MANAGE = 2;

    /**
     * 默认站点管理员角色
     */
    String DEFAULT_SITE_ADMIN_ROLE_CODE_SUFFIX = "_site_admin";

    /**
     * 新建企业的跟组织 code
     */
    String DEFAULT_COMPANY_ORG_ROOT_CODE_SUFFIX = "_org_root";

    /**
     * 模块类型
     */
    Integer MODULE_TYPE_DEFAULT = 1;
    Integer MODULE_TYPE_COMPANY = 2;
    Integer MODULE_TYPE_SITE = 3;

    /**
     * 资源状态
     */
    Integer RESOURCE_TYPE_PEDDING = 0;  //待处理
    Integer RESOURCE_TYPE_USEFUL = 1;   //有效
    Integer RESOURCE_TYPE_UNUSEFUL = 2; //无效

    /**
     * 菜单模块code
     */
    enum moduleType {
        course,
        exam,
        research,
        vote,
        marketingCourse,
        live,
        assignment,
        certificate,
        lesson,
        trainingProject,
        system,
        site,
        banner,
        message,
        point,
        customProject,
        caseLibrary,
        album,
        report,
        drools,
        task,
        practice,

        statistics_login,
        statistics_course,
        statistics_offlineCourse,
        statistics_marketingCourse,
        statistics_trainingProject,
        statistics_exam,
        statistics_research,
        statistics_vote,
        statistics_point,
        statistics_experience,
        statistics_sign,
        statistics_certificate,
        statistics_caseLibrary,
        statistics_album,
        statistics_report;
    }
}
