package com.yizhi.system.application.feign;

import java.util.List;

import javax.servlet.http.HttpServletResponse;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import com.yizhi.system.application.vo.domain.AuthzAccountRole;
import com.yizhi.system.application.vo.practice.OrgAccountVo;
import com.yizhi.util.application.domain.Response;

@FeignClient(name = "system", contextId = "AuthFeignClient")
public interface AuthFeignClient {

	@PostMapping("/api/loginBindWechat")
	public Response<String> noLoginWechat(HttpServletResponse httpResponse,
			@RequestParam(name = "openId", required = true) String openId,
			@RequestParam(name = "userId", required = true) Long userId);
	
	
	@GetMapping("/manage/role/report/get/all/admin")
	public List<AuthzAccountRole> getAllAdmin();
	
	@GetMapping("/manage/authz/org/get")
	public OrgAccountVo getOrgAndUserOfAdmin(@RequestParam("accountId") Long accountId, @RequestParam("siteId") Long siteId);
}
