package com.yizhi.system.application.feign;

import com.yizhi.system.application.vo.domain.Dictionary;
import com.yizhi.util.application.domain.Response;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * com.yizhi.application.feign
 *
 * @author yanglang
 * @create 2024-12-20 15:52:40
 */
@FeignClient(name = "system", contextId = "DictionaryFeignClients")
public interface DictionaryFeignClients {

    @GetMapping(value = "/dictionary/insertBySearchName")
    boolean insertBySearchName(@RequestParam("searchName") String searchName);

    @GetMapping(value = "/dictionary/child/listByCode1")
    List<Dictionary> listChildDictionary(@RequestParam(name = "code", defaultValue = "0") String code,
                                                   @RequestParam(name = "includeParent", defaultValue = "false") Boolean includeParent,
                                                   @RequestParam(name = "layer", defaultValue = "1") Integer layer);
}
