package com.yizhi.system.application.request;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 站点维护导出请求体
 */
@Data
@ApiModel(value = "站点维护导出")
public class SiteProtectExportReq {

    @ApiModelProperty(value = "维护记录id集合")
    private List<String> siteNoticeIdList;

    public List<Long> getSiteNoticeIdList() {
        final ArrayList<Long> objects = Lists.newArrayList();
        siteNoticeIdList.forEach(a->objects.add(StringUtils.isBlank(a)?null:Long.parseLong(a)));
        return objects;
    }
}