/**
 *
 */
package com.yizhi.system.application.system.remote;

import com.yizhi.system.application.model.AccountNameForIdsModel;
import com.yizhi.system.application.model.PermitModel;
import com.yizhi.system.application.model.RangeModel;
import com.yizhi.system.application.model.SiteOrgIdModel;
import com.yizhi.system.application.vo.domain.Account;
import com.yizhi.system.application.vo.*;
import com.yizhi.util.application.page.PageInfo;
import com.yizhi.core.application.vo.DroolsVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * 日志服务远程调用接口
 * 注意:
 * 方法注解不要使用GetMapping,要使用RequestMapping
 * 如果是Get请求,方法参数要加上RequestParam,否则Feign组件会当作是Post请求
 *
 * @author scotthu
 * @date 2018年2月28日
 */

@FeignClient(value = "system", contextId = "AccountClient")
public interface AccountClient {

    @PostMapping(value = "/remote/account/update")
    public Boolean updateAccount(@RequestBody AccountVO accountVO);

    /**
     * 根据用户名查询用户信息
     *
     * @param name
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/remote/account/name/search", method = RequestMethod.GET)
    public List<AccountVO> fuzzySearchAccountByName(@RequestParam("name") String name, @RequestParam("companyId") Long companyId) throws Exception;

    /**
     * 判断账号对站点是否有访问权限
     *
     * @param accountId
     * @param siteId
     * @return
     */
    @RequestMapping(value = "/remote/account/access/site", method = RequestMethod.GET)
    public boolean isAccessToSite(@RequestParam("accountId") Long accountId, @RequestParam("siteId") Long siteId);

    /**
     * 根据id查账号信息
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/remote/account/get", method = RequestMethod.GET)
    public AccountVO findById(@RequestParam("id") Long id);

    /**
     * 根据账号id列表查账号信息
     *
     * @param ids
     * @return
     */
    @RequestMapping(value = "/remote/account/list", method = RequestMethod.POST)
    public List<AccountVO> findByIds(@RequestBody List<Long> ids);

    /**
     * 查取站点下所有的员工
     *
     * @param siteId
     * @return
     */
    @RequestMapping(value = "/remote/account/list/siteid", method = RequestMethod.GET)
    public List<AccountVO> findBySiteId(@RequestParam("siteId") Long siteId);

    /**
     * 根据部门名字模糊匹配部门名称和code，查出部门以及子部门的员工信息
     *
     * @param orgName
     * @return
     */
    @RequestMapping(value = "/remote/account/list/orgname", method = RequestMethod.GET)
    public List<AccountVO> findByOrgName(@RequestParam("orgName") String orgName, @RequestParam("companyId") Long companyId);

    /**
     * 根据accountId，查询siteId站点下包含accountId的部门id列表和用户组id列表
     *
     * @param accountId
     * @param siteId
     * @return
     */
    @RequestMapping(value = "/remote/account/list/chief/ids", method = RequestMethod.GET)
    public List<Long> getCheifIds(@RequestParam("accountId") Long accountId, @RequestParam("siteId") Long siteId);

    /**
     * 部门下所有的用户
     *
     * @param orgId
     * @param companyId
     * @return
     */
    @RequestMapping(value = "/remote/account/list/orgid", method = RequestMethod.GET)
    public List<AccountVO> findByOrgId(@RequestParam("orgId") Long orgId, @RequestParam("companyId") Long companyId);

    /**
     * 用户组下所有的用户
     *
     * @param groupId
     * @param companyId
     * @return
     */
    @RequestMapping(value = "/remote/account/list/groupid", method = RequestMethod.GET)
    public List<AccountVO> findByGroupId(@RequestParam("groupId") Long groupId, @RequestParam("companyId") Long companyId);

    /**
     * 获取用户的操作权限列表
     *
     * @param accountId
     * @param siteId
     * @return
     */
    @RequestMapping(value = "/remote/account/list/permit", method = RequestMethod.GET)
    public PermitModel getPermits(@RequestParam("accountId") Long accountId, @RequestParam("siteId") Long siteId);

    /**
     * 根据用户名，姓名，或部门名称查询账号列表
     *
     * @param userInfoVO
     * @return
     */
    @RequestMapping(value = "/remote/account/list/userinfo", method = RequestMethod.POST)
    public Map<Long, UserInfoVO> selectUserInfo(@RequestBody UserInfoVO userInfoVO);

    /**
     * 根据用户名，姓名，或部门名称查询账号列表
     *
     * @param userInfoVO
     * @return
     */
    @RequestMapping(value = "/remote/account/list/getUser", method = RequestMethod.POST)
    public Map<Long, UserInfoVO> getUser(@RequestBody UserInfoVO userInfoVO);

    /**
     * 查询用户列表
     * @param userInfoVO
     * @return
     */
    @PostMapping(value = "/remote/account/find/userInfo/list")
    List<Account> getUserInfoVOList(@RequestBody UserInfoVO userInfoVO);

    /**
     * 排序插叙用户的ids
     * @param accountIdList
     * @return
     */
    @PostMapping(value = "/remote/account/find/accountId/list")
    List<Long> selectAccountIdList(@RequestBody List<Long> accountIdList);

    /**
     * 分页查询账号
     *
     * @param accountVO
     * @return
     */
    @RequestMapping(value = "/remote/account/list/page", method = RequestMethod.POST)
    public PageInfo<AccountVO> list(@RequestBody AccountPageVO accountVO);

    /**
     * 查询管理员
     * @param accountVO
     * @return
     */
    @PostMapping(value = "/remote/account/manager/page")
    PageInfo<AccountVO> managerList(@RequestBody AccountPageVO accountVO);
    /**
     * 根据相关类型和id查询用户信息
     * key为count时，value为人数
     * key为account时，value为用户列表
     *
     * @param members
     * @return
     */
    @RequestMapping(value = "/remote/account/find/members", method = RequestMethod.POST)
    public Map<String, Object> findMemberInfo(@RequestBody List<RangeModel> models);

    /**
     * 部门下所有的用户(管辖范围调整后查询组织下的用户方法)
     *
     * @param orgId
     * @param companyId
     * @return
     */
    @RequestMapping(value = "/remote/account/find/orgid", method = RequestMethod.GET)
    public List<AccountVO> accountsFindByOrgId(@RequestParam("orgId") Long orgId, @RequestParam("companyId") Long companyId);

    @PostMapping(value = "/remote/account/ids/get")
    public List<AccountVO> idsGet(@RequestBody List<Long> ids);

    /**
     * 微信新增用户
     *
     * @param accountVO
     * @return
     */
    @PostMapping(value = "/remote/account/add/get")
    public AccountVO addAccount(@RequestBody AccountRegisterVO accountVO);

    @GetMapping("/remote/account/site/count")
    Integer getSiteAccountNum(@RequestParam("siteId") Long siteId, @RequestParam("companyId") Long companyId);

    /**
     * 获取指定站点、部门下的人数（包括子部门）
     *
     * @param model
     * @return
     */
    @GetMapping(value = "/remote/account/site/org/count")
    Integer getSiteOrgWithChildAccountNum(@RequestBody SiteOrgIdModel model);

    /**
     * 根据账号id查询用户名片信息
     * @param accountId
     * @return
     */
    @GetMapping(value = "/remote/account/card/get")
    public AccountVO findCardById(@RequestParam(value = "accountId") long accountId);

    /**
     * 企业微信的用户的新增
     * @param weChatUserVO 参数
     * @return 用户实体
     */
    @PostMapping(value = "/remote/account/insert/cwechatuser")
    public Account saveUser(@RequestBody WeChatUserVO weChatUserVO);

    /**
     * 根据用户关键字查询关联的用户Id集合(改接口需要在中台调用，不适合业务微服务调用,其他微服务请调findAIdsByKeywordByVo)
     * @param key
     * @param companyId
     * @return
     */
    @GetMapping(value = "/remote/account/accountIds/keyword/get")
    public List<Long> findAIdsByKeyword(@RequestParam("key") String key,
                                        @RequestParam("companyId") Long companyId);

    @PostMapping(value = "/remote/account/accountIds/keyword/byVo")
    public List<Long> findAIdsByKeywordByVo(@RequestBody AccountIdsByKeyReqVO vo);

    /**
     * 根据用户名和公司id查询用户详情
     * @param name 用户名称
     * @param companyId
     * @return
     */
    @RequestMapping(value = "/remote/account/name/find", method = RequestMethod.GET)
    public AccountVO findUser(@RequestParam("name") String name, @RequestParam("companyId") Long companyId);

    @PostMapping(value = "/remote/account/find/accountOrgs")
    public List<AccountOrgsVO> findCcountOrgs(@RequestBody AccountOrgsRepVO vo);

    @PostMapping("/remote/account/name/id/get")
    Map<String, Long> getAccountIdByNames(@RequestBody AccountNameForIdsModel model,
                                          @RequestParam("companyId") Long companyId,
                                          @RequestParam("siteId") Long siteId,
                                          @RequestParam("moduleType") String moduleType);

    /**
     * 丁小伟添加,外部经验导入需要用户的部门id和部门名称
     * @param model
     * @param companyId
     * @param siteId
     * @param moduleType
     * @return
     */
    @PostMapping("/remote/account/name/account/get")
    Map<String, Map<String,Object>> getAccountByNames(@RequestBody AccountNameForIdsModel model,
                                          @RequestParam("companyId") Long companyId,
                                          @RequestParam("siteId") Long siteId,
                                          @RequestParam("moduleType") String moduleType);


    /**
     * 申万宏源新增用户
     *
     * @param accountVO
     * @return
     */
    @PostMapping(value = "/remote/account/add/swhy")
    public AccountVO addSwhyAccount(@RequestBody Account account);

    /**
     * 申万宏源新增用户
     *
     * @param accountVO
     * @return
     */
    @PostMapping(value = "/remote/account/disable/swhy")
    public Boolean disableSwhyAccount(@RequestParam("companyId") Long companyId, @RequestParam("userName") String userName);


    /**
     * 根据companId,id查询账号姓名
     * @param companyId
     * @param ids
     * @return
     */

    @GetMapping("/manage/account/idName")
    public List<Account> accountList(@RequestParam(name = "companyId") Long companyId, @RequestParam(name = "ids", required = false) List<Long> ids);

    /**
     * 获取指定站点、部门下的人数（包括子部门）
     *
     * @param model
     * @return
     */
    @PostMapping(value = "/remote/account/site/org/counts")
    List<Account> getSiteOrgWithChildAccountNums(@RequestBody SiteOrgIdModel model);

    @GetMapping("/manage/account/org/isEnable/list")
    List<Long> listAccountIdByOrgIdAndEnable(@RequestParam("orgId") Long orgId, @RequestParam("isEnable") Boolean isEnable);


    @GetMapping("/remote/account/getAccountByMobile")
    public List<Account> getAccountByMobile(@RequestParam("mobile") String mobile);

    @GetMapping("/remote/account/getAccountCount")
    public Map<Long, Integer> getAccountCount(@RequestParam("companyId") Long companyId);

    @GetMapping("/remote/account/getPageByDrools")
    PageInfo<DroolsVo> getPageByDrools(@RequestParam("field") String field,
                                       @RequestParam(value = "value", required = false) String value,
                                       @RequestParam("pageNo") Integer pageNo,
                                       @RequestParam("pageSize") Integer pageSize);
    @PostMapping("/remote/account/getPageByRuleItems")
    PageInfo<DroolsAccountVO> getPageByRuleItems(@RequestBody RuleVisibleRangeVo ruleVisibleRangeVo);

    /**
     * 保存用户
     * @param account
     * @return
     */
    @PostMapping("/remote/account/insert/third/account")
    Account saveThirdAccount(@RequestBody Account account);

    /**
     * 管辖区内用户id
     * @return
     */
    @GetMapping(value = "/manage/org/group/accountId/list")
    List<Long> getAccountIds();

    @GetMapping("/remote/account/byId")
    Account getAccountById(@RequestParam(name = "id") Long id);

    /**
     * 获取用户列表
     * @param authorizeUsersVO
     * @return
     */
    @PostMapping("/remote/account/accountIds")
    Map<Long,Account> getAccountList(@RequestBody AuthorizeUsersVO authorizeUsersVO);

    /**
     * 按用户名查询
     * @param name
     * @param companyId
     * @return
     */
    @GetMapping("/remote/account/findAccountByName")
    Account findAccountByName(@RequestParam(name = "name") String name,@RequestParam(name = "companyId") Long companyId);


    /**
     * 保存供应商的用户的信息
     * @param weChatUserVO
     * @return
     */
    @PostMapping(value = "/remote/account/insert/provider/user")
    Account saveProviderUser(@RequestBody WeChatUserVO weChatUserVO);

    @GetMapping("/remote/account/searchByConditionWithPriority")
    ResponseEntity<Account> searchByConditionWithPriority(@RequestParam(name = "companyId") Long companyId,
                                                          @RequestParam(name = "account") String account,
                                                          @RequestParam(name = "mobile") String mobile,
                                                          @RequestParam(name = "email") String email);
    /**
     * 社群人员同步
     * @param date
     * @return
     */
    @GetMapping(value="/remote/account/public/community/syncAccount")
    public String syncAccount(@RequestParam("indexTime") String indexTime);

}
