package com.yizhi.system.application.system.remote;

import com.yizhi.system.application.model.AccountRangeExportParam;
import com.yizhi.system.application.model.AccountRangeImportModel;
import com.yizhi.system.application.model.AccountRangeImportParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 可见范围导入、导出
 *
 * @Author: shengchenglong
 * @Date: 2018/9/5 11:47
 */
@FeignClient(value = "system", contextId = "AccountRangeClient")
public interface AccountRangeClient {

    /**
     * 可见范围导入，返回用户id
     *
     * @param param
     * @return
     */
    @PostMapping("/remote/account/range/import")
    AccountRangeImportModel doImport(@RequestBody AccountRangeImportParam param);

    /**
     * 可见范围导出，返回任务名称
     *
     * @param param
     * @return
     */
    @PostMapping("/remote/account/range/export")
    String doExport(@RequestBody AccountRangeExportParam param);

    /**
     * 经验池可见范围导出，返回任务名称
     *
     * @param param
     * @return
     */
    @PostMapping("/remote/account/range/experiencePoolExport")
    String doExperiencePoolExport(@RequestBody AccountRangeExportParam param);
}
