package com.yizhi.system.application.system.remote;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.system.application.vo.LanguageParam;
import com.yizhi.system.application.vo.LanguageVo;

@FeignClient(name = "system", contextId = "LanguageClient")
public interface LanguageClient {

	@PostMapping("/language/upload")
	public String upload(@RequestBody LanguageParam param);
	
	@PostMapping("/language/update")
	public int update(@RequestBody LanguageVo vo);
	
	@PostMapping("/language/list")
	public Page<LanguageVo> list(@RequestBody LanguageParam param);
	
	@PostMapping("/language/export")
	public String export(@RequestBody LanguageParam param);
}
