/**
 *
 */
package com.yizhi.system.application.system.remote;

import com.yizhi.system.application.vo.OrgVO;
import com.yizhi.system.application.vo.UpOrgVO;
import com.yizhi.system.application.vo.UserGroupVO;
import com.yizhi.system.application.vo.WeChatUpdateOrganizationVo;
import com.yizhi.system.application.vo.domain.Organization;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 部门Client
 * 注意:
 * 方法注解不要使用GetMapping,要使用RequestMapping
 * 如果是Get请求,方法参数要加上RequestParam,否则Feign组件会当作是Post请求
 *
 * @author scotthu
 * @date 2018年2月28日
 */

@FeignClient(value = "system", contextId = "OrganizationClient")
public interface OrganizationClient {
    /**
     * 根据部门名字，code模糊查询用户信息
     *
     * @param name
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/remote/org/name/search", method = RequestMethod.GET)
    public List<OrgVO> fuzzySearchOrgByName(@RequestParam("name") String name, @RequestParam("companyId") Long companyId) throws Exception;

    /*
    * 根据部门id 查询子部门信息
    * */
    @RequestMapping(value = "/remote/org/pid/search", method = RequestMethod.GET)
    public List<Organization> selectAllByPId(@RequestParam("pId") Long pId);
    /**
     * 根据部门ids获取部门列表的信息
     *
     * @param ids
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/remote/org/ids/list", method = RequestMethod.POST)
    public List<OrgVO> listByOrgIds(@RequestBody List<Long> ids) throws Exception;

    /**
     * 根据用户组ids获取用户组列表的信息
     *
     * @param ids
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/remote/group/ids/list", method = RequestMethod.POST)
    public List<UserGroupVO> listByGroupIds(@RequestBody List<Long> ids) throws Exception;

    /**
     * 查询子组织id
     *
     * @param orgId
     * @param companyId
     * @return
     */
    @RequestMapping(value = "/remote/org/child/ids", method = RequestMethod.GET)
    public List<Long> getChildIds(@RequestParam("orgId") Long orgId, @RequestParam("companyId") Long companyId);

    /**
     * 包含父组织名称集合
     *
     * @param orgId
     * @param companyId
     * @return
     */
    @RequestMapping(value = "/remote/org/chief/names", method = RequestMethod.GET)
    public List<String> getChiefOrgNames(@RequestParam("orgId") Long orgId, @RequestParam("companyId") Long companyId);

    /**
     * 根据关键字查询包含该关键字的组织code和name匹配的orgId
     *
     * @param key
     * @param companyId
     * @return
     */
    @GetMapping(value = "/remote/orgId/keyword")
    public List<Long> findOrgIdByNameOrCode(@RequestParam("key") String key,
                                            @RequestParam("companyId") Long companyId);

    /**
     * 根据关键字查询包含该关键字的组织name匹配的orgId
     *
     * @param key
     * @param companyId
     * @return
     */
    @GetMapping(value = "/remote/orgId/nameKeyword")
    List<Long> findOrgIdByName(@RequestParam("key") String key, @RequestParam("companyId") Long companyId);

    @PostMapping(value = "/remote/orgId/upOrgs")
    Map<Long, UpOrgVO> findupOrgsByOrgId(@RequestBody List<Long> orgIds);

    /**
     * 查询当前组织的上级组织
     * @param orgId
     * @return
     */
    @GetMapping(value = "/remote/orgId/parentIds")
    List<Long> orgIdParentIds(@RequestParam("orgId") Long orgId);

    /**
     * 查询组织的上级组织名称
     * @param orgIds
     * @return
     */
    @PostMapping(value = "/remote/orgIds/parentNames")
    Map<Long, List<String>> selectOrgsParentOrgs(@RequestBody List<Long> orgIds);

    /**
     * 获取 父级部门名称-当前部门名称
     * @param orgIds
     * @return
     */
    @PostMapping("/remote/org/ids/parent/combineNames")
    Map<Long, String> getParentNameWithCurrentName(@RequestBody List<Long> orgIds);

    @PostMapping("/remote/org/index/rebuild")
    Boolean rebuildOrgIndex(@RequestBody ArrayList<String> companyCodes);

    @GetMapping("/remote/org/index/rebuild/job")
    Boolean rebuildOrgIndexJob(@RequestParam("companyId") Long companyId);

    @GetMapping("/remote/org/getChildIds")
    Set<Long> getChildIds(@RequestParam("orgId") Long orgId);

    /**
     * 丁小伟添加根据部门id获取部门名称
     * @param orgIds
     * @return
     */
    @GetMapping("/remote/org/getOrgNames")
    Map<Long, String> getOrgNames(@RequestParam("orgIds") List<Long> orgIds);

    @GetMapping("/remote/org/getOrgIds")
    Set<Long> getOrgIdsInSite(@RequestParam("siteId") Long siteId, @RequestParam("companyCode") String companyCode, @RequestParam("siteCode") String siteCode);

    @GetMapping("/remote/getAccountOrgFullNameList")
    Map<Long, String> getAccountOrgFullNameMap(@RequestParam(name = "companyId") Long companyId);

    /**
     * 用于企业微信更新部门信息
     *
     * @param vo
     * @return
     */
    @PostMapping("/remote/weChat/update/organization")
    WeChatUpdateOrganizationVo updateOrganization(@RequestBody WeChatUpdateOrganizationVo vo);


    /**
     * 社群管辖区人员同步
     * @param date
     * @return
     */
    @GetMapping(value="/remote/org/public/community/syncOrg")
    public String syncOrg(@RequestParam("indexTime") String indexTime);
}
