package com.yizhi.system.application.system.remote;

import com.yizhi.system.application.vo.domain.SwhyKey;
import com.yizhi.system.application.vo.OutsideUserVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "system", contextId = "OutsideSystemClient")
public interface OutsideSystemClient {

    @GetMapping(value = "/remote/outside/account/beta/user")
    List<OutsideUserVO> getRcUsers(@RequestParam("userName") String userName,
                                      @RequestParam("companyId") Long companyId,
                                      @RequestParam("siteId") String siteId);

    @GetMapping(value = "/remote/outside/account/appId/info/get")
    SwhyKey getSwhyKeyConfig(@RequestParam("appId") String appId, @RequestParam("companyId") Long companyId);
}
