package com.yizhi.system.application.system.remote;

import com.yizhi.system.application.vo.domain.DaIndicatorCourseFinish;
import com.yizhi.system.application.vo.domain.DaIndicatorCourseTime;
import com.yizhi.system.application.vo.domain.DaIndicatorTpFinish;
import com.yizhi.system.application.vo.RemoteDaIndicatorVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @ClassName DaIndicatorAccountController
 * @Description TODO
 * @Author shengchenglong
 * @DATE 2019-10-09 16:52
 * @Version 1.0
 */
@FeignClient(name = "system", contextId = "RemoteDaIndicatorSystemClient")
public interface RemoteDaIndicatorSystemClient {

    /**
     * dashboard - 活跃用户比例
     *
     * @return
     */
    @PostMapping("/remote/da/system/account")
    boolean account(@RequestBody RemoteDaIndicatorVo vo);

    @PostMapping("/remote/da/system/insertCourseFinish")
    boolean insertCourseFinish(@RequestBody DaIndicatorCourseFinish record);

    @PostMapping("/remote/da/system/insertCourseTime")
    boolean insertCourseTime(@RequestBody DaIndicatorCourseTime record);

    @PostMapping("/remote/da/system/insertTpFinish")
    boolean insertTpFinish(@RequestBody DaIndicatorTpFinish record);

    @PostMapping("/remote/da/system/accountDay")
    boolean accountDay(@RequestBody RemoteDaIndicatorVo vo);

}
