package com.yizhi.system.application.utils.recursion;

import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 11:17 2018/4/24
 * @Modified By
 */
public class RecursionUtils {

    public static final String patternString1 = "\"id\":\\d+";
    //public static final Pattern pattern1 = Pattern.compile(patternString1, Pattern.DOTALL);
    public static final Pattern pattern1 = Pattern.compile(patternString1);


    public static TreeObjectVO getSubTree(TreeObjectVO init, final List<TreeObjectVO> data, final long orgId){
        TreeObjectVO retTree = new TreeObjectVO();
        if(CollectionUtils.isEmpty(data)){
            return retTree;
        }
        List<TreeObjectVO> subList = data.stream().parallel().filter(item -> Long.valueOf(orgId).equals(item.getParentId())).collect(Collectors.toList());
        if(init == null){
            Optional<TreeObjectVO> topTree = data.stream().parallel().filter(item -> item.getId().longValue()==orgId).findFirst();
            if(! topTree.isPresent()){
                return topTree.orElse(new TreeObjectVO());
            }
            BeanUtils.copyProperties(topTree.get(),retTree);
            retTree.setSubList(subList);
        }else{
            init.setSubList(subList);
        }

        for (TreeObjectVO item : subList) {
            getSubTree(item, data, item.getId());
        }
        return retTree;
    }


    public static TailRecursion<TreeObjectVO> getParentIdTree(TreeObjectVO childNodeObj,final List<TreeObjectVO> data,
                                                           final Long childNodeId){
        if (childNodeId == null || childNodeId.longValue()==0) {
            return TailInvoke.done(childNodeObj);
        } else {
            Optional<TreeObjectVO> parentTree = data.stream().parallel().filter(item -> item.getId().longValue()==childNodeId).findFirst();
            if(! parentTree.isPresent()){
                return TailInvoke.done(new TreeObjectVO());
            }
            Long pid = parentTree.get().getParentId();
            Optional<TreeObjectVO> toptTree = data.stream().parallel().filter(item -> item.getId().longValue()==pid).findFirst();
            TreeObjectVO topObj = toptTree.get();
            return TailInvoke.call(() -> getParentIdTree(topObj.setMember(childNodeObj), data,pid ));
        }
    }

    public static long getParentId(final List<TreeObjectVO> data, final Long childNodeId){
        Map<Long,TreeObjectVO> tmpMap = data.stream().collect(Collectors.toMap(TreeObjectVO::getId,TreeObjectVO::cloneThos));//或者x -> x.getId(), x -> x.getName()
        // 如果存在重复的可以会报错，TreeObjectVO::getId,TreeObjectVO::cloneThos,(oldValue, newValue) -> oldValue先出现的保留(newValue后出现的保留)
        // 如果需要排序，在stream()后加.sorted(Comparator.comparingLong(Hosting::getWebsites).reversed())，然后在转toMap参数最后加,LinkedHashMap::new
        return 0;
    }

    public static boolean extisData(String strData,Pattern pattern){
        boolean ret = false;
        Matcher m = pattern.matcher(strData);
        if(m.matches()){
            ret = true;
        }
        return ret;
    }

    public static List<Long> filterTreeId(String strData){
        List<Long> ret = new ArrayList<Long>();
        Matcher m = pattern1.matcher(strData);
        while(m.find()) {
            Long id = Long.valueOf(m.group(0).split(":")[1]);
            ret.add(id);
        }
        return ret;
    }


}
