package com.yizhi.system.application.vo;

import com.baomidou.mybatisplus.annotations.TableField;
import com.yizhi.system.application.vo.domain.AuthzMenu;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 模块
 * </p>
 *
 * @author yinyuyan123
 * @since 2018-05-16
 */
@Data
@Api(tags = "AuthzMenu", description = "菜单")
public class AuthzMenuVo2 implements Comparable{

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键id")
    private Long id;

    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "对应功能模块code")
    private String code;

    @ApiModelProperty(value = "描述")
    private String description;

    @ApiModelProperty(value = "是否不需要权限")
    
    private Boolean ifPublic;

    @ApiModelProperty(value = "父模块id，本身为顶级则为0")
    private Long parentId;

    @ApiModelProperty(value = "顶级菜单 id 到该菜单 id 的集合，逗号分隔，顶级菜单为自身 id")

    private String parentIdLayer;

    @ApiModelProperty(value = "归属类型：1通用类型：全平台所有站点可见；2企业类型：指定企业内所有站点可见；3站点类型：指定站点内可见。")
    private Integer type;

    @ApiModelProperty(value = "是否是运营菜单")
    private Boolean operationMenu;

    @ApiModelProperty(value = "默认站点有效（其他附属站点无效）")
    private Boolean defaultSiteOnly;

    @ApiModelProperty(value = "是否可以被资源归属")
    private Integer hasResource;

    @ApiModelProperty(value = "前端路由")
    private String url;

    @ApiModelProperty(value = "排序")
    private Integer sort;

    @ApiModelProperty(value = "是否启用")
    private Integer enabled;

    @ApiModelProperty(value = "是否删除")
    private Integer deleted;

    @ApiModelProperty(value = "菜单类型 ： 0 目录 1 页面 2 分隔符")
    private Integer menuType;

    @ApiModelProperty(value = "菜单级别 ： 1 一级菜单 2 二级菜单 3 三级菜单")
    private Integer menuLevel=1;

    @ApiModelProperty(value = "所属企业id，type=1或3时为0")
    private Long companyId;

    @ApiModelProperty(value = "所属站点id，type=1或2时为0")
    private Long siteId;

    @ApiModelProperty(value = "创建者id")
    private Long createById;

    @ApiModelProperty(value = "创建者名称")
    private String createByName;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新者id")
    private Long updateById;

    @ApiModelProperty(value = "修改者名称")
    private String updateByName;

    @ApiModelProperty(value = "修改时间")
    private Date updateTime;

    @ApiModelProperty(value = "icon")
    private String icon;

    @ApiModelProperty(value = "activeIcon")
    private String activeIcon;

    @ApiModelProperty(value = "menu的子级分类")
    
    private List<AuthzMenuVo2> childrenMenus;
    @ApiModelProperty(value = "menu的父亲名称")
    
    private String parentName;

    public AuthzMenuVo2() {
    }

    public AuthzMenuVo2(AuthzMenu authzMenu) {
        this.id = authzMenu.getId();
        this.name = authzMenu.getName();
        this.code = authzMenu.getCode();
        this.description = authzMenu.getDescription();
        this.ifPublic = authzMenu.getIfPublic();
        this.parentId = authzMenu.getParentId();
        this.parentIdLayer = authzMenu.getParentIdLayer();
        this.type = authzMenu.getType();
        this.operationMenu = authzMenu.getOperationMenu();
        this.defaultSiteOnly = authzMenu.getDefaultSiteOnly();
        this.hasResource = authzMenu.getHasResource();
        this.url = authzMenu.getUrl();
        this.sort = authzMenu.getSort();
        this.enabled = authzMenu.getEnabled();
        this.deleted = authzMenu.getDeleted();
        this.menuType = authzMenu.getMenuType();
        this.companyId = authzMenu.getCompanyId();
        this.siteId = authzMenu.getSiteId();
        this.createById = authzMenu.getCreateById();
        this.createByName = authzMenu.getCreateByName();
        this.createTime = authzMenu.getCreateTime();
        this.updateById = authzMenu.getUpdateById();
        this.updateByName = authzMenu.getUpdateByName();
        this.updateTime = authzMenu.getUpdateTime();
        this.icon = authzMenu.getIcon();
        this.activeIcon = authzMenu.getActiveIcon();
    }

    @Override
    public int compareTo(Object o) {
        AuthzMenuVo2 node = (AuthzMenuVo2) o;
        if (null == node.getSort() || null == this.getSort()) {
            return 0;
        }
        return this.getSort() - node.getSort();
    }
}

