package com.yizhi.system.application.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import java.util.List;

/**
 * 资源编辑的表单类
 */
@Data
@ApiModel(value = "AuthzResourceVo",description = "资源编辑时的表单类")
public class AuthzResourceVo {
    @ApiModelProperty(value = "资源id")
    @NotBlank
    private Long id;

    @ApiModelProperty(value = "资源名称")
    private String name;

    @ApiModelProperty(value = "模块编码")
    private String moduleCode;

    @ApiModelProperty(value = "图标")
    private String icon;

    @ApiModelProperty(value = "资源类型（P：页面，B：按钮）")
    private String type;

    @ApiModelProperty(value = "资源路径")
    private String url;

    @ApiModelProperty(value = "0-待处理、1-有效、2-无效")
    private Integer status;

    @ApiModelProperty(value = "上级")
    private Long parentId;

    @ApiModelProperty(value = "菜单Id")
    private List<Long> menuIds;




}
