package com.yizhi.system.application.vo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 我的首页列表项目对象
 *
 * @author yinyuyan 2018-04-03
 */
@Data
@Api(tags = "MyItemVO", description = "我的首页列表项目")
public class MyItemVO {

    @ApiModelProperty(value = "编码")
    private String code;

    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "数量")
    private Integer quantity;

    @ApiModelProperty(value = "目前仅对我的学时存储数量")
    private Float quantityFloat;

    @ApiModelProperty(value = "排序")
    private Integer sortNo;

    @ApiModelProperty(value = "配合前端在PC端跳转页面所需addUrl")
    private String addUrl;
    
    @ApiModelProperty(value = "logo图标地址")
    private String logoImg;

    public MyItemVO() {
        super();
    }

    public MyItemVO(String code, String name, Integer quantity) {
        super();
        this.code = code;
        this.name = name;
        this.quantity = quantity;
    }

    public MyItemVO(String code, String name, Integer quantity, String addUrl) {
        super();
        this.code = code;
        this.name = name;
        this.quantity = quantity;
        this.addUrl = addUrl;
    }
}
