package com.yizhi.system.application.vo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * <p>
 * 站点
 * </p>
 *
 * @author fulan123
 * @since 2018-03-08
 */
@Data
@Api(tags = "SitePageVO", description = "站点传输对象")
public class SitePageVO{

    @ApiModelProperty(value = "站点名称")
	private String name;

    @ApiModelProperty(value = "编码")
	private String code;

    @ApiModelProperty(value = "是否开通")
	private Boolean enabled;
	
	@ApiModelProperty(value = "成员类型(1:子站点2:业务站点)")
	private Integer type;

	@ApiModelProperty(value = "是否需要主站点的数据")
	private Boolean needMainSite = false;
	
	@ApiModelProperty(value = "第几页")
	private Integer pageNo=1;

	@ApiModelProperty(value = "第几页")
	private Integer pageSize=10;
}
