package com.yizhi.system.application.vo;

import com.yizhi.system.application.enums.SiteNoticeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

@Data
@ApiModel("站点维护列表实体")
public class SiteProtectVO {

    @ApiModelProperty(value = "维护名称",name = "name")
    private String name;

    @ApiModelProperty(value = "维护主体id",name = "id")
    private String id;

    @ApiModelProperty(value = "维护通知记录id",name = "siteNoticeId")
    private String siteNoticeId;

    @ApiModelProperty(value = "开始时间",name = "startTime")
    private String startTime;

    @ApiModelProperty(value = "结束时间",name = "endTime")
    private String endTime;

    @ApiModelProperty(name = "siteProtectStatus",value = "状态",allowableValues = "1未开始 2进行中 3已结束")
    private String siteProtectStatus;

    @ApiModelProperty(name = "siteNoticeEnum",value = "维护方式")
    private SiteNoticeEnum siteNoticeEnum;

    public Long getId() {
        return StringUtils.isBlank(id)?null:Long.parseLong(id);
    }

    public Long getSiteNoticeId() {
        return StringUtils.isBlank(siteNoticeId)?null:Long.parseLong(siteNoticeId);
    }
}
