package com.yizhi.system.application.vo.domain;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 员工关联角色
 * </p>
 *
 * @author 谢海军
 * @since 2018-03-09
 */
@Data
@Api(tags = "AuthzAccountRole", description = "员工关联角色")
public class AuthzAccountRole {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "账号id")
    private Long accountId;

    @ApiModelProperty(value = "角色id")
    private Long roleId;

    @ApiModelProperty(value = "站点id")
    private Long siteId;

    @ApiModelProperty(value = "创建者id")
    private Long createById;

    @ApiModelProperty(value = "创建者名称")
    private String createByName;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;



	public AuthzAccountRole() {
		super();
	}


	public AuthzAccountRole(Long id, Long accountId, Long roleId, Long siteId) {
		super();
		this.id = id;
		this.accountId = accountId;
		this.roleId = roleId;
		this.siteId = siteId;
	}
}
