package com.yizhi.system.application;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.amqp.RabbitAutoConfiguration;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.hystrix.EnableHystrix;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;

@EnableHystrix
@SpringBootApplication(exclude = {RabbitAutoConfiguration.class})
@EnableDiscoveryClient
@EnableFeignClients(basePackages = "com.yizhi")
@EnableAsync
@ComponentScan(basePackages = {"com.yizhi"})
public class SystemApplication {
    private static final Logger logger = LoggerFactory.getLogger(SystemApplication.class);

    public static void main(String[] args) throws UnknownHostException {
        Environment env = SpringApplication.run(SystemApplication.class, args).getEnvironment();
        String port = env.getProperty("server.port", "8080");

        logger.info(
                "Access URLs:\n----------------------------------------------------------\n\t"
                        + "Local: \t\thttp://10.10.12.97:{}\n\t"
                        + "External: \thttp://{}:{}\n----------------------------------------------------------",
                port, InetAddress.getLocalHost().getHostAddress(), port);
    }

    @Bean  //帮助调其他服务时，能取到上下文里面的信息
    public RequestInterceptor headerInterceptor() {
        return new RequestInterceptor() {
            @Override
            public void apply(RequestTemplate requestTemplate) {
                ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder
                        .getRequestAttributes();
                if (attributes != null) {
                    HttpServletRequest request = attributes.getRequest();
                    Enumeration<String> headerNames = request.getHeaderNames();
                    if (headerNames != null) {
                        while (headerNames.hasMoreElements()) {
                            String name = headerNames.nextElement();
                            String values = request.getHeader(name);
                            requestTemplate.header(name, values);
                        }
                    }
                }
            }
        };
    }

}

