package com.yizhi.system.application.constant;

/**
 *站点维护异常信息
 */
public enum  SiteProtectExceptionEnum {
    PROTECT_FAIL("8500","操作异常"),
    PROTECT_UNKNOWN_FAIL("8600","未知操作异常"),
    PROTECT_DATA_INVALID("8601","站点维护数据不符合限制条件"),
    PROTECT_TIME_IS_NULL("8602","设置站点维护失败！通知时间包含空值!"),
    PROTECT_SUBMIT_REPEAT("8603","重复提交!"),
    PROTECT_NAME_REPEAT("8604","站点维护名称重复!"),
    PROTECT_NAME_IS_NULL("8605","站点维护名称为空!"),
    PROTECT_NOTICE_IS_NULL("8606","站点维护通知数据为空!"),
    PROTECT_PART_SITE_IS_NULL("8607","自定义选择站点为空!"),
    PROTECT_NOTICE_DATA_INVALID("8608","无效的维护数据!"),
    PROTECT_NOTICE_TIME_INVALID("8609","维护通知时间小于当前时间!"),
    PROTECT_NOTICE_END("8610","不能修改已结束的维护数据!"),
    PROTECT_NOTICE_START_TIME_INVALID("8611","维护已开始，不能修改开始时间!"),
    NO_CHOOSE_SITE("8612","没有选中的维护记录!"),
    NO_DETAIL_ID("8613","没有选中的维护记录ID"),
    PARAM_NULL("8614","参数为空或空字符"),
    PROTECT_NOTICE_START("8615","不能删除已开始的维护数据!")
    ;
    private String errCode;
    private String msg;

    SiteProtectExceptionEnum(String errCode, String msg) {
        this.errCode = errCode;
        this.msg = msg;
    }

    public String getErrCode() {
        return errCode;
    }

    public String getMsg() {
        return msg;
    }
}
