package com.yizhi.system.application.controller.api;

import com.yizhi.application.orm.util.DomainConverter;
import com.yizhi.application.orm.util.QueryUtil;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.system.application.service.AuthService;
import com.yizhi.system.application.service.ISiteService;
import com.yizhi.system.application.vo.SiteVO;
import com.yizhi.util.application.domain.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.*;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 10:19 2018/4/4
 * @Modified By
 */
@Api(tags = "站点接口")
@RestController
@RequestMapping(value = "/api/site")
public class SiteApi {

    @Autowired
    ISiteService siteService;
    @Autowired
    private AuthService authService;
    @Autowired
    private DomainConverter converter;

    @ApiOperation(value = "根据站点名称查询", notes = "根据站点名称查询")
    @GetMapping(value = "/public/getSiteByName")
    public Response<String> getCompanyByName(@ApiParam(required = true, value = "企业ID") @RequestParam Long companyId,
                                             @ApiParam(required = true, value = "站点名称") @RequestParam String siteName){
        Map<String,Object> retMap = new HashMap<>();
        com.yizhi.system.application.domain.Site site = new com.yizhi.system.application.domain.Site();
        site.setCompanyId(companyId);
        site.setName(siteName);
        com.yizhi.system.application.domain.Site retSite = siteService.selectOne(QueryUtil.condition(site));
        String siteCode = "";
        if(retSite != null){
            siteCode = retSite.getCode();
        }
        retMap.put("siteCode",siteCode);
        return Response.ok(retMap);
    }

    @ApiOperation(value = "根据企业code获取站点")
    @GetMapping(value = "/public/companyCode/list")
    public Response<SiteVO> getAllSiteByCompanyCode(@RequestParam("companyCode") String companyCode) {
        List<com.yizhi.system.application.domain.Site> sites = siteService.getAllSiteByCompanyCode(companyCode);
        if (CollectionUtils.isNotEmpty(sites)) {
            return Response.ok(converter.toVOList(sites, SiteVO.class));
        }
        return Response.ok(new ArrayList<>());
    }

    @ApiOperation(value = "学员可访问站点列表", response = SiteVO.class)
    @GetMapping(value = "/front/list")
    public Response<SiteVO> frontList() {
        RequestContext context = ContextHolder.get();
        Set<Long> siteIds = authService.AccessSiteIdsFront(context.getCompanyId(), context.getCompanyCode(), context.getAccountId());
        if (CollectionUtils.isNotEmpty(siteIds)) {
            List<com.yizhi.system.application.domain.Site> sites = siteService.selectBatchIds(siteIds);
            List<SiteVO> vos = converter.toVOList(sites, SiteVO.class);
            return Response.ok(vos);
        }
        return null;
    }

}
