package com.yizhi.system.application.controller.manage;


import java.util.List;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.yizhi.application.orm.util.DomainConverter;
import com.yizhi.system.application.domain.Site;
import com.yizhi.system.application.model.AuthAccountSiteModel;
import com.yizhi.system.application.service.AuthService;
import com.yizhi.system.application.service.IOrganizationService;
import com.yizhi.system.application.vo.SiteVO;
import com.yizhi.system.application.vo.practice.OrgAccountVo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * @Author: shengchenglong
 * @Date: 2018/3/20 10:15
 */
@Api(tags = "数据权限接口")
@RestController
@RequestMapping("/manage/authz")
public class AuthorityController {

    private static final Logger LOGGER = LoggerFactory.getLogger(AuthorityController.class);

    @Autowired
    private AuthService authService;
    @Autowired
    private IOrganizationService organizationService;
    @Autowired
    DomainConverter converter;


    @GetMapping("/site/access/list")
    @ApiOperation("管理端：可以管理的站点列表")
    public List<SiteVO> getAccessSite(@RequestParam("accountId") Long accountId) {
        List<Site> sites = authService.getAccessSite(accountId);
        return converter.toVOList(sites, SiteVO.class);
    }

    @GetMapping("/site/access")
    @ApiOperation("管理端：是否可以访问一个站点")
    public Boolean isAccessToSite(@RequestParam("accountId") Long accountId, @RequestParam("companyId") Long companyId,
                                  @RequestParam("siteId") Long siteId) {
        Set<Long> siteIds = authService.AccessSiteIds(companyId, accountId);
        if (!CollectionUtils.isEmpty(siteIds)) {
            return siteIds.contains(siteId);
        }
        return false;
    }

    @GetMapping("/site/get")
    @ApiOperation(value = "管理端：指定站点的数据权限接口")
    public AuthAccountSiteModel getSiteAutho(@RequestParam("companyId") Long companyId,
                                             @RequestParam("companyCode") String companyCode,
                                             @RequestParam("accountId") Long accountId,
                                             @RequestParam("siteId") Long siteId,
                                             @RequestParam("key") String key) {
        return authService.getSiteAutho(companyCode, companyId, accountId, siteId, key);
    }

    @GetMapping("/site/url/get")
    @ApiOperation(value = "管理端：指定站点url的管辖范围")
    public Set<Long> getSiteUrlAutho(@RequestParam("companyId") Set<Long> orgIds) {
        return organizationService.listChildrenId(orgIds);
    }

    @GetMapping("/site/access/front")
    @ApiOperation("学员端：是否可以访问一个站点")
    public Boolean isAccessToSiteFront(@RequestParam("accountId") Long accountId,
                                       @RequestParam("companyId") Long companyId,
                                       @RequestParam("companyCode") String companyCode,
                                       @RequestParam("siteId") Long siteId) {
        Set<Long> siteIds = authService.AccessSiteIdsFront(companyId, companyCode, accountId);
        if (!CollectionUtils.isEmpty(siteIds)) {
            return siteIds.contains(siteId);
        }
        return false;
    }

    @GetMapping("/site/relationIds/front")
    public List<Long> getRelationIds(@RequestParam("accountId") Long accountId, @RequestParam("companyId") Long companyId,
                                     @RequestParam("siteId") Long siteId) {
        return authService.getRelationIds(companyId, accountId, siteId);
    }

    @GetMapping("/org/get")
    @ApiOperation("管理端：获取登陆的人 所 关联的 组织和用户")
    public OrgAccountVo getOrgAndUserOfAdmin(@RequestParam("accountId") Long accountId, @RequestParam("siteId") Long siteId) {
        return authService.getOrgAndUserOfAdmin(accountId, siteId);
    }

    @GetMapping("/visiable/retain/count")
    @ApiOperation("管理端：获取登陆的人 所 关联的 组织和用户")
    public Integer getVisibleAndManageRetain(@RequestParam("accountId") Long accountId,
                                             @RequestParam("siteId") Long siteId,
                                             @RequestParam("companyId") Long companyId,
                                             @RequestParam("serviceVisibleOrgIds") List<Long> serviceVisibleOrgIds,
                                             @RequestParam("serviceVisibleUserIds") List<Long> serviceVisibleUserIds) {
        return authService.getOverlapUserCount(
                authService.getOrgAndUserOfAdmin(accountId, siteId),
                serviceVisibleOrgIds,
                serviceVisibleUserIds,
                siteId,
                companyId);
    }

}
