package com.yizhi.system.application.controller.manage;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.core.application.exception.BizException;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.system.application.service.IAuthzMenuResourceService;
import com.yizhi.system.application.service.IAuthzResourceService;
import com.yizhi.system.application.vo.domain.AuthzResource;
import com.yizhi.util.application.domain.Response;
import com.yizhi.system.application.vo.AuthzResourceVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

@Api("权限资源管理")
@RestController
@RequestMapping("/manage/authResource")
public class AuthzResourceController {

    @Autowired
    IAuthzResourceService authzResourceService;

    @Autowired
    IAuthzMenuResourceService authzMenuResourceService;

    @Autowired
    IdGenerator idGenerator;

    /**
     * 添加一条资源
     *
     * @param authzResource
     * @return
     */
    @ApiOperation(value = "添加一条资源", response = Boolean.class)
    @PostMapping("/save")
    Response saveAuthzResource(@ApiParam(name = "authzResource") @RequestBody AuthzResource authzResource) {
        try {
            com.yizhi.system.application.domain.AuthzResource authzResource1 = new com.yizhi.system.application.domain.AuthzResource();
            BeanUtils.copyProperties(authzResource,authzResource1);
            return Response.ok(authzResourceService.saveAuthzResource(authzResource1));
        } catch (BizException e) {
            return Response.fail(e.getCode(), e.getMsg());
        }
    }

    /**
     * 删除一条资源
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "删除一条资源", response = Boolean.class)
    @GetMapping("/delete")
    Response deleteAuthzResource(@ApiParam(name = "资源Id 必传") @RequestParam(value = "id") Long id) {
        try {
            return Response.ok(authzResourceService.deleteAuthzResource(id));
        } catch (BizException e) {
            return Response.fail(e.getCode(), e.getMsg());
        }
    }

    /**
     * 编辑资源
     *
     * @param authzResource
     * @return
     */
    @ApiOperation(value = "编辑资源", response = Boolean.class)
    @PostMapping("/update")
    Response updateAuthzResource(@ApiParam(name = "authzResource") @RequestBody AuthzResource authzResource) {

        try {
            com.yizhi.system.application.domain.AuthzResource authzResource1 = new com.yizhi.system.application.domain.AuthzResource();
            BeanUtils.copyProperties(authzResource,authzResource1);
            return Response.ok(authzResourceService.updateAuthzResource(authzResource1));
        } catch (BizException e) {
            return Response.fail(e.getCode(), e.getMsg());
        }
    }

    /**
     * 根据ID查询一条资源
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "查询一条资源", response = AuthzResource.class)
    @GetMapping("/get")
    Response<AuthzResource> queryAuthzResourceById(@ApiParam(name = "资源Id 必传") @RequestParam(value = "id") Long id) {
        try {
            return Response.ok(authzResourceService.queryAuthzResource(id));
        } catch (Exception e) {
            return Response.fail(e.getMessage());
        }
    }

    /**
     * 分页查询资源信息
     *
     * @param name
     * @param pageNo
     * @param pageSize
     * @return
     */
    @ApiOperation(value = "分页查询资源信息", response = AuthzResource.class)
    @GetMapping("/pageList")
    Response<com.yizhi.system.application.domain.AuthzResource> ListAuthzResource(@ApiParam(value = "资源名称") @RequestParam(value = "name", required = false) String name,
                                              @ApiParam(value = "资源状态") @RequestParam(value = "status", required = false) Integer status,
                                              @ApiParam(value = "pageNo") @RequestParam(value = "pageNo", required = false,defaultValue = "1") Integer pageNo,
                                              @ApiParam(value = "pageSize") @RequestParam(value = "pageSize", required = false,defaultValue = "50") Integer pageSize) {
        Page<com.yizhi.system.application.domain.AuthzResource> page = authzResourceService.ListAuthzResource(name, status, pageNo, pageSize);
        Map<String,Integer> pageMap  = new HashMap();
        pageMap.put("pageNo", page.getCurrent());
        pageMap.put("pageSize", page.getSize());
        pageMap.put("pageTotal", page.getPages());
        return Response.ok(page,pageMap);
    }

    /**
     * 忽略操作
     * @param id
     * @return
     */
    @ApiOperation(value = "",response =Boolean.class )
    @GetMapping("/ignoreAction")
    Response<Boolean> ignoreAction(@ApiParam(name = "资源Id 必传") @RequestParam(value = "id") Long id){
        try {
            return Response.ok(authzResourceService.ignoreAction(id));
        } catch (Exception e) {
            return Response.fail(e.getMessage());
        }
    }


    /**
     * 编辑资源Vo
     *
     * @param authzResourceVo
     * @return
     */
    @ApiOperation(value = "编辑资源Vo", response = Boolean.class)
    @PostMapping("/updateAuthzResourceVo")
    Response updateAuthzResourceVo(@ApiParam(name = "authzResourceVo") @RequestBody AuthzResourceVo authzResourceVo) {
        try {
            return Response.ok(authzResourceService.updateAuthzResourceVo(authzResourceVo));
        } catch (BizException e) {
            return Response.fail(e.getCode(), e.getMsg());
        }
    }

    /**
     * 根据菜单ID，查询对应资源
     *
     * @param menuId
     * @return
     */
    @ApiOperation(value = "根据菜单ID，查询对应资源", response = AuthzResource.class)
    @GetMapping("/MenuResourceList")
    Response<AuthzResource> menuResourceList(@ApiParam(name = "菜单Id 必传") @RequestParam(value = "menuId") Long menuId) {
        try {
            return Response.ok(authzResourceService.menuResourceList(menuId));
        } catch (Exception e) {
            return Response.fail(e.getMessage());
        }
    }

}
