package com.yizhi.system.application.controller.manage;


import com.yizhi.system.application.domain.AuthzResource;
import com.yizhi.system.application.service.IAuthzResourceService;
import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.domain.Response;
import com.yizhi.system.application.vo.OperationVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 操作表 前端控制器
 * </p>
 *
 * @author 谢海军
 * @since 2018-03-09
 */
@Api(tags = "操作权限管理接口")
@RestController
@RequestMapping("/manage/operation")
public class OperationController {

    private static final Logger logger = LoggerFactory.getLogger(OperationController.class);

    @Autowired
    private IAuthzResourceService operationService;


    /**
     * 查询操作父节点
     *
     * @return
     */
    @ApiOperation(value = "查询操作父节点", notes = "查询操作父节点")
    @GetMapping(value = "/parent/list")
    public Response<OperationVO> list() {
        try {
            List<com.yizhi.system.application.domain.AuthzResource> retList = operationService.getParentOperations();
            return Response.ok(retList);
        } catch (Exception e) {
            logger.error("", e);
           return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }

    }

    /**
     * 根据父节点查询子节点
     *
     * @param parentId
     * @return
     */
    @ApiOperation(value = "根据父节点查询子节点", notes = "根据父节点查询子节点")
    @GetMapping(value = "/childs/list")
    public Response<OperationVO> childsList(@RequestParam Long parentId) {
        try {
            Map<String, List<AuthzResource>> retMap = operationService.getSubOperations(parentId);
            return Response.ok(retMap);
        } catch (Exception e) {
            logger.error("", e);
           return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

    @ApiOperation(value = "查询树状菜单列表", notes = "查询树状菜单列表")
    @GetMapping(value = "/menu/list")
    public Response<List<OperationVO>> menuList() {
        try {
            List<OperationVO> menus = operationService.getMenuList();
            return Response.ok(menus);
        } catch (Exception e) {
            logger.error("", e);
           return Response.fail(ReturnCode.SERVICE_UNAVAILABLE.getCode(),ReturnCode.SERVICE_UNAVAILABLE.getMsg());
        }
    }

}

